/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.presentation;

import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.internal.core.TargletContainerDescriptorManager;
import org.eclipse.oomph.targlets.presentation.TargletEditorPlugin;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.ui.IMemento;

public final class TargletContainerEditorInput
extends URIEditorInput {
    public TargletContainerEditorInput(String containerID) {
        super(URI.createGenericURI((String)"targlet_container", (String)containerID, null), containerID);
    }

    public TargletContainerEditorInput(IMemento memento) {
        super(memento);
    }

    public String getContainerID() {
        return this.getURI().opaquePart();
    }

    public String getToolTipText() {
        String id = this.getContainerID();
        ITargletContainer targletContainer = TargletContainerDescriptorManager.getContainer((String)id);
        if (targletContainer == null) {
            return id;
        }
        ITargetDefinition targetDefinition = targletContainer.getTargetDefinition();
        boolean active = TargetPlatformUtil.isActiveTargetDefinition((ITargetDefinition)targetDefinition);
        return TargletContainerEditorInput.getContainerLabel(targletContainer, active);
    }

    protected String getBundleSymbolicName() {
        return TargletEditorPlugin.INSTANCE.getSymbolicName();
    }

    public static String getContainerLabel(ITargletContainer targletContainer, boolean active) {
        return String.valueOf(targletContainer.getID()) + " (" + targletContainer.getTargetDefinition().getName() + (active ? ", active" : "") + ")";
    }
}

