/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import java.text.MessageFormat;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender;
import org.eclipse.jet.internal.runtime.SafeCustomRuntimeTag;
import org.eclipse.jet.taglib.FunctionTag;

public class SafeFunctionRuntimeTag
extends SafeCustomRuntimeTag {
    private boolean bodyProcessed = false;
    private String functionResult;

    public SafeFunctionRuntimeTag(FunctionTag tag) {
        super(tag);
    }

    public void doStart(JET2Context startContext, JET2Writer startOut) {
        super.doStart(startContext, startOut);
        this.bodyProcessed = false;
    }

    public boolean okToProcessBody() {
        return !this.bodyProcessed;
    }

    public void handleBodyContent(final JET2Writer bodyContent) {
        this.bodyProcessed = true;
        this.functionResult = "";
        Platform.run((ISafeRunnable)new SafeCustomRuntimeTag.TagSafeRunnable(this){

            public void doRun() throws Exception {
                FunctionTag untrustedTag = (FunctionTag)SafeFunctionRuntimeTag.this.getUntrustedTag();
                SafeFunctionRuntimeTag.this.functionResult = untrustedTag.doFunction(SafeFunctionRuntimeTag.this.getTagInfo(), SafeFunctionRuntimeTag.this.getContext(), ((BufferedJET2Writer)bodyContent).getContent());
            }
        });
        RuntimeLoggerContextExtender.log(this.getContext(), MessageFormat.format(JET2Messages.TraceRuntimeTags_FunctionResult, this.functionResult), this.getTagInfo(), 2);
        this.getWriter().write(this.functionResult);
    }
}

