/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler.templates;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2TemplateLoader;
import org.eclipse.jet.JET2TemplateLoaderExtension;

public class CodeGenTemplateLoader
implements JET2TemplateLoader,
JET2TemplateLoaderExtension {
    private Map pathToFactoryMap = null;
    private JET2TemplateLoader delegate = null;

    public JET2Template getTemplate(String templatePath) {
        TemplateFactoryMethod factory;
        if (this.pathToFactoryMap == null) {
            this.initPathToFactoryMap();
        }
        return (factory = (TemplateFactoryMethod)this.pathToFactoryMap.get(templatePath)) == null ? (this.delegate == null ? null : this.delegate.getTemplate(templatePath)) : factory.newTemplate();
    }

    private void addTemplate(String templatePath, String templateClass) {
        this.pathToFactoryMap.put(templatePath, new TemplateFactoryMethod(templatePath, templateClass));
    }

    private void initPathToFactoryMap() {
        this.pathToFactoryMap = new HashMap(11);
        this.addTemplate("templates/jet2java.jet", "org.eclipse.jet.internal.compiler.templates.JET2JavaGenerator");
        this.addTemplate("templates/jet2transform.jet", "org.eclipse.jet.internal.compiler.templates.JET2TransformGenerator");
        this.addTemplate("templates/jetTemplateMap.properties.jet", "org.eclipse.jet.internal.compiler.templates.JETTemplateMapGenerator");
        this.addTemplate("templates/main.jet", "org.eclipse.jet.internal.compiler.templates.DummyMain");
        this.addTemplate("templates/tagDataDeclarations.jet", "org.eclipse.jet.internal.compiler.templates.TagDataDeclGenerator");
        this.addTemplate("templates/v1/jet2java.jet", "org.eclipse.jet.internal.compiler.templates.v1.JET1JavaGenerator");
        this.addTemplate("templates/v2/jet2java.jet", "org.eclipse.jet.internal.compiler.templates.v2.JET2JavaGeneratorNew");
        this.addTemplate("templates/writeJavaExpression.jet", "org.eclipse.jet.internal.compiler.templates.WriteJavaExpressionTemplate");
        this.addTemplate("templates/writeTextElement.jet", "org.eclipse.jet.internal.compiler.templates.WriteTextElementTemplate");
        this.addTemplate("templates/xmlEnd.jet", "org.eclipse.jet.internal.compiler.templates.XMLEndGenerator");
        this.addTemplate("templates/xmlStart.jet", "org.eclipse.jet.internal.compiler.templates.XMLStartGenerator");
    }

    public void setDelegateLoader(JET2TemplateLoader loader) {
        this.delegate = loader;
    }

    public JET2TemplateLoader getDelegateLoader() {
        return this.delegate;
    }

    private static final class TemplateFactoryMethod {
        private final String templatePath;
        private final String templateClass;

        public TemplateFactoryMethod(String templatePath, String templateClass) {
            this.templatePath = templatePath;
            this.templateClass = templateClass;
        }

        public String getTemplateClass() {
            return this.templateClass;
        }

        public String getTemplatePath() {
            return this.templatePath;
        }

        public JET2Template newTemplate() {
            JET2Template template = null;
            try {
                template = (JET2Template)Class.forName(this.templateClass).newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassNotFoundException classNotFoundException) {}
            return template;
        }
    }
}

