/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.taglib;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jet.IWriterListener;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.taglib.TagUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public final class UserRegionHelper
implements IWriterListener {
    private static final String INITIALCODE_POSITION_CATEGORY = "org.eclipse.jet.internal.taglib.control.initialcode";
    private static final String ROUNDTRIP_LISTENER_CATEGORY = "org.eclipse.jet.internal.taglib.control.userRegion";
    private static final String USERREGION_POSITION_CATEGORY = "org.eclipse.jet.internal.taglib.control.userRegion";

    private UserRegionHelper() {
    }

    public void finalizeContent(JET2Writer writer, Object file) {
        IFile iFile;
        if (file instanceof IFile && (iFile = (IFile)file).exists()) {
            String fileContents;
            try {
                fileContents = TagUtil.getContents(iFile.getLocation());
            }
            catch (CoreException coreException) {
                return;
            }
            Position[] rtPositions = writer.getPositions("org.eclipse.jet.internal.taglib.control.userRegion");
            Position[] icPositions = writer.getPositions(INITIALCODE_POSITION_CATEGORY);
            IDocument document = writer.getDocument();
            int i = 0;
            while (i < rtPositions.length) {
                try {
                    Position userRegionPosition = rtPositions[i];
                    Position initialCodePosition = this.findContainedInitialCodePosition(userRegionPosition, icPositions);
                    if (initialCodePosition != null) {
                        String existingRegion;
                        int existingEndMarkerOffset;
                        String unmodifiedMarker = initialCodePosition instanceof PositionWithUnmodifiedMarker ? ((PositionWithUnmodifiedMarker)initialCodePosition).unmodifiedMarker : null;
                        Position beginMarkerPosition = new Position(userRegionPosition.offset, initialCodePosition.offset - userRegionPosition.offset);
                        int endMarkerOffset = initialCodePosition.offset + initialCodePosition.length;
                        Position endMarkerPosition = new Position(endMarkerOffset, userRegionPosition.offset + userRegionPosition.length - endMarkerOffset);
                        String beginMarker = document.get(beginMarkerPosition.offset, beginMarkerPosition.length);
                        String endMarker = document.get(endMarkerPosition.offset, endMarkerPosition.length);
                        int existingRegionOffset = fileContents.indexOf(beginMarker);
                        if (!(existingRegionOffset == -1 || (existingEndMarkerOffset = fileContents.indexOf(endMarker, existingRegionOffset + beginMarker.length())) == -1 || (existingRegion = fileContents.substring(existingRegionOffset, existingEndMarkerOffset + endMarker.length())).equals(document.get(userRegionPosition.offset, userRegionPosition.length)) || unmodifiedMarker != null && existingRegion.indexOf(unmodifiedMarker) != -1)) {
                            document.replace(userRegionPosition.offset, userRegionPosition.length, existingRegion);
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
                ++i;
            }
        }
    }

    private Position findContainedInitialCodePosition(Position userRegionPosition, Position[] icPositions) {
        int i = 0;
        while (i < icPositions.length) {
            Position pos = icPositions[i];
            if (pos.offset + pos.length > userRegionPosition.offset + userRegionPosition.length) {
                return null;
            }
            if (userRegionPosition.offset <= pos.offset) {
                return pos;
            }
            ++i;
        }
        return null;
    }

    public void postCommitContent(JET2Writer writer, Object file) {
    }

    public static void markInitialCode(JET2Writer out, int initialCodeStart, int initialCodeEnd, String unmodifiedMarker) {
        out.addPositionCategory(INITIALCODE_POSITION_CATEGORY);
        if (unmodifiedMarker == null) {
            out.addPosition(INITIALCODE_POSITION_CATEGORY, new Position(initialCodeStart, initialCodeEnd - initialCodeStart));
        } else {
            out.addPosition(INITIALCODE_POSITION_CATEGORY, new PositionWithUnmodifiedMarker(initialCodeStart, initialCodeEnd - initialCodeStart, unmodifiedMarker));
        }
    }

    public static void markInitialCode(JET2Writer out, int initialCodeStart, int initialCodeEnd) {
        UserRegionHelper.markInitialCode(out, initialCodeStart, initialCodeEnd, null);
    }

    public static void markUserRegion(JET2Writer out, int regionStart, int regionEnd) {
        out.addPositionCategory("org.eclipse.jet.internal.taglib.control.userRegion");
        out.addPosition("org.eclipse.jet.internal.taglib.control.userRegion", new Position(regionStart, regionEnd - regionStart));
        out.addEventListener("org.eclipse.jet.internal.taglib.control.userRegion", new UserRegionHelper());
    }

    private static class PositionWithUnmodifiedMarker
    extends Position {
        public final String unmodifiedMarker;

        public PositionWithUnmodifiedMarker(int offset, int length, String unmodifiedMarker) {
            super(offset, length);
            this.unmodifiedMarker = unmodifiedMarker;
        }
    }
}

