/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.embedded.impl;

import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.NegotiationException;
import org.eclipse.net4j.core.Negotiator;
import org.eclipse.net4j.core.impl.AbstractConnector;
import org.eclipse.net4j.core.impl.BufferImpl;
import org.eclipse.net4j.embedded.EmbeddedConnector;

public abstract class AbstractEmbeddedConnector
extends AbstractConnector
implements EmbeddedConnector {
    protected EmbeddedConnector peer;

    public void receive(int channelIndex, BufferImpl buffer) {
        Channel channel = this.getChannel(channelIndex);
        channel.notifyData(buffer);
    }

    public Negotiator getNegotiator() {
        throw new UnsupportedOperationException();
    }

    public void setNegotiator(Negotiator negotiator) {
        throw new UnsupportedOperationException();
    }

    public byte[] receiveNegotiation() throws NegotiationException {
        throw new UnsupportedOperationException();
    }

    public void transmitNegotiation(byte[] data) throws NegotiationException {
        throw new UnsupportedOperationException();
    }

    public EmbeddedConnector getPeer() {
        return this.peer;
    }

    public void setPeer(EmbeddedConnector peer) {
        this.doSet("peer", peer);
    }

    public void transmit(int channelIndex, BufferImpl buffer) {
        BufferImpl copy = this.getBufferPool().getBuffer();
        copy.put(buffer);
        copy.flip();
        this.peer.receive(channelIndex, copy);
    }

    public boolean isPeerOnSameHost() {
        return true;
    }

    protected void deactivate() throws Exception {
        this.peer = null;
        super.deactivate();
    }
}

