/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.ResourceInfo;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.client.impl.ResourceInfoImpl;
import org.eclipse.emf.cdo.examples.client.internal.ExampleClientPlugin;
import org.eclipse.emf.cdo.examples.ui.ResourceFactoryHelper;
import org.eclipse.emf.cdo.examples.ui.UIUtils;
import org.eclipse.emf.cdo.examples.ui.internal.ExampleUIActivator;
import org.eclipse.emf.cdo.examples.ui.internal.wizards.CDOImportWizardPage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class CDOImportWizard
extends Wizard
implements IImportWizard {
    public static final String WIZARD_ID = "org.eclipse.emf.cdo.examples.ui.CDOImportWizard";
    public static final String TITLE = "Import CDO Resource";
    private CDOImportWizardPage page;
    private ResourceManager resourceManager;
    private boolean commit;
    private IStructuredSelection selection;

    public CDOImportWizard(ResourceManager resourceManager, boolean commit) {
        if (resourceManager == null && !commit) {
            throw new IllegalArgumentException("resourceManager == null && !commit");
        }
        this.resourceManager = resourceManager;
        this.commit = commit;
        this.setDialogSettings(CDOImportWizard.getCDOImportWizardDialogSettings());
        this.setWindowTitle(TITLE);
        this.setNeedsProgressMonitor(true);
    }

    public CDOImportWizard() {
        this(null, true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.page = new CDOImportWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public static IDialogSettings getCDOImportWizardDialogSettings() {
        IDialogSettings workbenchSettings = ExampleUIActivator.getPlugin().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("CDOImportWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("CDOImportWizard");
        }
        return section;
    }

    public boolean performFinish() {
        final String sourceURI = this.page.getSourceURI();
        final String resourceFactoryExtension = this.page.getResourceFactoryExtension();
        final String destinationPath = this.page.getDestinationPath();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    CDOImportWizard.this.doFinish(sourceURI, resourceFactoryExtension, destinationPath, monitor);
                }
                catch (Exception ex) {
                    throw new InvocationTargetException(ex);
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        this.page.saveValues();
        if (this.resourceManager == null) {
            UIUtils.openCDOEditor((ResourceInfo)new ResourceInfoImpl(destinationPath, 0, true));
        }
        return true;
    }

    private void doFinish(String sourceURI, String resourceFactoryExtension, String destinationPath, IProgressMonitor monitor) throws Exception {
        EObject[] contents;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map map = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        map.put("*", ResourceFactoryHelper.getResourceFactory(resourceFactoryExtension));
        Resource source = resourceSet.getResource(URI.createURI((String)sourceURI), true);
        ResourceManager resourceManager = this.resourceManager == null ? ExampleClientPlugin.createResourceManager((ResourceSet)new ResourceSetImpl()) : this.resourceManager;
        URI uri = URI.createURI((String)("cdo://" + destinationPath));
        CDOResource target = (CDOResource)resourceManager.createResource(uri);
        EObject[] eObjectArray = contents = (EObject[])source.getContents().toArray();
        int n = 0;
        int n2 = eObjectArray.length;
        while (n < n2) {
            EObject object = eObjectArray[n];
            target.getContents().add((Object)object);
            ++n;
        }
        if (this.commit) {
            resourceManager.commit();
        }
        if (this.resourceManager == null) {
            resourceManager.stop();
        }
    }
}

