/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.examples.ocl.wizards;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.query.examples.ocl.internal.l10n.QueryOCLMessages;
import org.eclipse.emf.query.examples.ocl.wizards.IOCLQueryWizardPage;
import org.eclipse.emf.query.ocl.conditions.BooleanOCLCondition;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContextFreeQueryWizardPage
extends WizardPage
implements IOCLQueryWizardPage {
    private static String TITLE = QueryOCLMessages.cfQuery_title;
    private static String CONDITION_PROMPT = QueryOCLMessages.cfQuery_prompt_condition;
    private static String CONDITION_DEFAULT = QueryOCLMessages.cfQuery_default_condition;
    private Text conditionText;
    private BooleanOCLCondition<EClassifier, EClass, EObject> condition;

    public ContextFreeQueryWizardPage() {
        super("main", TITLE, null);
    }

    public void createControl(Composite parent) {
        this.setMessage(QueryOCLMessages.oclQuery_message_wizard);
        Composite page = new Composite(parent, 0);
        page.setLayout((Layout)new GridLayout(1, false));
        Label prompt = new Label(page, 0);
        prompt.setText(CONDITION_PROMPT);
        this.conditionText = new Text(page, 0x2000802);
        this.conditionText.setLayoutData((Object)new GridData(1808));
        this.conditionText.setText(CONDITION_DEFAULT);
        this.conditionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ContextFreeQueryWizardPage.this.setPageComplete(ContextFreeQueryWizardPage.this.validatePage());
            }
        });
        this.setControl((Control)page);
        this.setPageComplete(this.validatePage());
    }

    private boolean validatePage() {
        boolean result = true;
        try {
            String text = this.conditionText.getText();
            OCL ocl = OCL.newInstance();
            this.condition = new BooleanOCLCondition(ocl.getEnvironment(), text, null);
            this.setErrorMessage(null);
        }
        catch (Exception e) {
            result = false;
            this.setErrorMessage(e.getLocalizedMessage());
        }
        return result;
    }

    @Override
    public BooleanOCLCondition<EClassifier, EClass, EObject> getCondition() {
        return this.condition;
    }

    public void dispose() {
        super.dispose();
    }
}

