/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.internal.server.protocol.AbstractSyncRevisionsIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.net4j.util.concurrent.RWLockManager;
import org.eclipse.net4j.util.io.IORuntimeException;

public class LockObjectsIndication
extends AbstractSyncRevisionsIndication {
    private RWLockManager.LockType lockType;
    private List<CDOID> ids = new ArrayList<CDOID>();
    private List<CDOIDAndVersion> idAndVersions = new ArrayList<CDOIDAndVersion>();
    private IView view;

    public LockObjectsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)25);
    }

    protected void indicating(CDODataInput in) throws IOException {
        super.indicating(in);
        int viewID = in.readInt();
        this.lockType = in.readCDOLockType();
        long timeout = in.readLong();
        try {
            this.view = this.getSession().getView(viewID);
            this.getRepository().getLockManager().lock(this.lockType, this.view, this.ids, timeout);
        }
        catch (InterruptedException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        for (CDOIDAndVersion idAndVersion : this.idAndVersions) {
            this.udpateObjectList(idAndVersion.getID(), idAndVersion.getVersion());
        }
        if (!this.detachedObjects.isEmpty()) {
            this.getRepository().getLockManager().unlock(this.lockType, this.view, this.ids);
            throw new IllegalArgumentException(String.valueOf(this.detachedObjects.size()) + " objects are not persistent anymore");
        }
        super.responding(out);
    }

    protected void process(CDOID id, int version) {
        this.ids.add(id);
        this.idAndVersions.add(CDOIDUtil.createIDAndVersion((CDOID)id, (int)version));
    }
}

