/*
 * Copyright (c) 2017 Contributors to the Eclipse Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.eclipse.microprofile.rest.client.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * When annotation is placed at the interface level of a REST API definition, the providers listed will be registered upon proxying.
 * <p>
 * If a provider listed is not found on the classpath, it is ignored.  If a provider is listed, but is not a valid provider, then an
 * {@link IllegalArgumentException} is thrown indicating that the provider is invalid.
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Repeatable(RegisterProviders.class)
public @interface RegisterProvider {
    /**
     * @return the provider class to register on this client interface
     */
    Class<?> value();

    /**
     *
     * @return the priority of the provider.  If not specified, reads the priority from the annotation
     * {@link javax.annotation.Priority} as defined on the class
     */
    int priority() default -1;
}
