/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.navigator.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mdht.uml.ui.navigator.UMLDomainNavigatorItem;
import org.eclipse.mdht.uml.ui.navigator.internal.l10n.Messages;
import org.eclipse.mdht.uml.ui.navigator.internal.plugin.Logger;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.uml2.uml.Element;

public class OpenModelAction
implements IObjectActionDelegate {
    private IWorkbenchPart activePart;
    private List files = new ArrayList();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.files = new ArrayList();
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        for (IFile file : sSelection) {
            this.files.add(file);
        }
        action.setEnabled(!this.files.isEmpty());
    }

    public boolean isEnabled() {
        return !this.files.isEmpty();
    }

    public void run(IAction action) {
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.mdht.uml.common.ui.EditingDomain");
        for (IFile modelFile : this.files) {
            try {
                Resource resource = editingDomain.getResourceSet().getResource(URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true), true);
                if (!(this.activePart instanceof CommonNavigator)) continue;
                List items = this.wrapItems((List)resource.getContents(), modelFile);
                StructuredSelection selection = new StructuredSelection(items);
                ((CommonNavigator)this.activePart).getCommonViewer().setSelection((ISelection)selection, true);
            }
            catch (Exception e) {
                String message = NLS.bind((String)Messages.OpenModelAction_errorMessage, (Object[])new String[]{e.getLocalizedMessage()});
                Logger.logException(message, e);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.OpenModelAction_errorTitle, (String)message);
            }
        }
    }

    private List wrapItems(List items, Object parentElement) {
        ArrayList<UMLDomainNavigatorItem> wrappedItems = new ArrayList<UMLDomainNavigatorItem>();
        for (Object item : items) {
            if (!(item instanceof Element)) continue;
            wrappedItems.add(new UMLDomainNavigatorItem((EObject)((Element)item), parentElement, null));
        }
        return wrappedItems;
    }
}

