/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.actions;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.ui.internal.Logger;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class RemoveValidationMessagesAction
implements IObjectActionDelegate {
    protected IWorkbenchPart activePart;
    protected ISelection currentSelection;
    protected Element selectedElement;

    protected View getSelectedView() {
        for (Object element : (IStructuredSelection)this.currentSelection) {
            View view = (View)((IAdaptable)element).getAdapter(View.class);
            if (view == null) continue;
            return view;
        }
        return null;
    }

    private void removeAllConformanceMessages(Element element) {
        TreeIterator iterator = EcoreUtil.getAllContents(Collections.singletonList(element));
        while (iterator != null && iterator.hasNext()) {
            EObject child = (EObject)iterator.next();
            UMLSwitch<Object> umlSwitch = new UMLSwitch<Object>(){

                public Object caseAssociation(Association association) {
                    CDAModelUtil.setValidationMessage((Element)association, null);
                    return association;
                }

                public Object caseClass(Class umlClass) {
                    CDAModelUtil.setValidationMessage((Element)umlClass, null);
                    return umlClass;
                }

                public Object caseConstraint(Constraint constraint) {
                    CDAModelUtil.setValidationMessage((Element)constraint, null);
                    return constraint;
                }

                public Object caseProperty(Property property) {
                    CDAModelUtil.setValidationMessage((Element)property, null);
                    Association association = property.getAssociation();
                    if (association != null) {
                        CDAModelUtil.setValidationMessage((Element)association, null);
                    }
                    return property;
                }
            };
            umlSwitch.doSwitch(child);
        }
    }

    public void run(IAction action) {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.selectedElement);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Remove Validation Messages"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    RemoveValidationMessagesAction.this.removeAllConformanceMessages(RemoveValidationMessagesAction.this.selectedElement);
                    return Status.OK_STATUS;
                }
            };
            try {
                IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)editingDomain.getCommandStack();
                operation.addContext(commandStack.getDefaultUndoContext());
                commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException ee) {
                Logger.logException(ee);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
        this.selectedElement = null;
        if (((IStructuredSelection)selection).size() == 1) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof IAdaptable) {
                selected = ((IAdaptable)selected).getAdapter(EObject.class);
            }
            if (selected instanceof View) {
                selected = ((View)selected).getElement();
            }
            if (selected instanceof Element) {
                this.selectedElement = (Element)selected;
            }
        }
        if (this.selectedElement != null && CDAProfileUtil.getAppliedCDAProfile((Element)this.selectedElement) != null) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }
}

