/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.properties.internal.sections;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mdht.uml.common.ui.dialogs.DialogLaunchUtil;
import org.eclipse.mdht.uml.common.ui.search.GeneralizationTypeFilter;
import org.eclipse.mdht.uml.common.ui.search.IElementFilter;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.ui.properties.sections.WrapperAwareModelerPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;

public class ClassifierSection
extends WrapperAwareModelerPropertySection {
    private Classifier classifier;
    private Button isAbstract;
    private boolean isAbstractModified = false;
    private CLabel baseTypeName;
    private Button typeButton;

    private void modifyFields() {
        if (!this.isAbstractModified) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.classifier);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    if (!ClassifierSection.this.isAbstractModified) {
                        return Status.CANCEL_STATUS;
                    }
                    ClassifierSection.this.isAbstractModified = false;
                    this.setLabel("Set Abstract");
                    ClassifierSection.this.classifier.setIsAbstract(ClassifierSection.this.isAbstract.getSelection());
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void openBaseTypeDialog() {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.classifier);
        final NamedElement type = DialogLaunchUtil.chooseElement((IElementFilter)new GeneralizationTypeFilter(this.classifier), (Package)UMLUtil.getTopPackage((Element)this.classifier), (Shell)this.getPart().getSite().getShell());
        if (type != null) {
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Set Base Type"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    if (ClassifierSection.this.classifier.getGeneralizations().isEmpty()) {
                        ClassifierSection.this.classifier.createGeneralization((Classifier)type);
                    } else {
                        Generalization generalization = (Generalization)ClassifierSection.this.classifier.getGeneralizations().get(0);
                        generalization.setGeneral((Classifier)type);
                        Classifier owner = generalization.getSpecific();
                        int position = owner.getGeneralizations().lastIndexOf((Object)generalization);
                        owner.getGeneralizations().remove((Object)generalization);
                        owner.getGeneralizations().add(position, (Object)generalization);
                    }
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormData data = null;
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int buttonHeight = point.y + 10;
        gc.dispose();
        shell.dispose();
        CLabel typeLabel = this.getWidgetFactory().createCLabel(composite, "Base Type:");
        this.baseTypeName = this.getWidgetFactory().createCLabel(composite, "");
        this.typeButton = this.getWidgetFactory().createButton(composite, "Select Type...", 8);
        this.typeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ClassifierSection.this.openBaseTypeDialog();
            }
        });
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.baseTypeName, -5);
        data.top = new FormAttachment(0, 2, 0);
        typeLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 105);
        data.right = new FormAttachment((Control)this.typeButton, -5);
        data.top = new FormAttachment(0, 2, 0);
        this.baseTypeName.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(60, 0);
        data.top = new FormAttachment(0, 2, 0);
        data.height = buttonHeight;
        this.typeButton.setLayoutData((Object)data);
        this.isAbstract = this.getWidgetFactory().createButton(composite, "Abstract", 32);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(1, 2, 6);
        this.isAbstract.setLayoutData((Object)data);
        this.isAbstract.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ClassifierSection.this.isAbstractModified = true;
                ClassifierSection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                ClassifierSection.this.isAbstractModified = true;
                ClassifierSection.this.modifyFields();
            }
        });
    }

    @Override
    protected boolean isReadOnly() {
        TransactionalEditingDomain editingDomain;
        if (this.classifier != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.classifier)) != null && editingDomain.isReadOnly(this.classifier.eResource())) {
            return true;
        }
        return super.isReadOnly();
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        if (element instanceof View) {
            element = ((View)element).getElement();
        }
        Assert.isTrue((boolean)(element instanceof Classifier));
        this.classifier = (Classifier)element;
    }

    public void dispose() {
        super.dispose();
        this.classifier = null;
    }

    public void refresh() {
        this.isAbstract.setSelection(this.classifier.isAbstract());
        Classifier general = null;
        if (!this.classifier.getGeneralizations().isEmpty()) {
            Generalization generalization = (Generalization)this.classifier.getGeneralizations().get(0);
            general = generalization.getGeneral();
        }
        if (general != null) {
            this.baseTypeName.setText(general.getQualifiedName());
        } else {
            this.baseTypeName.setText("");
        }
        if (this.isReadOnly()) {
            this.isAbstract.setEnabled(false);
            this.typeButton.setEnabled(false);
        } else {
            this.isAbstract.setEnabled(true);
            this.typeButton.setEnabled(true);
        }
    }

    public void update(final Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!ClassifierSection.this.isDisposed() && !ClassifierSection.this.isNotifierDeleted(notification)) {
                        ClassifierSection.this.refresh();
                    }
                }
            });
        }
    }
}

