/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.dita;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.core.profile.LogicalConstraint;
import org.eclipse.mdht.uml.cda.core.util.CDACommonUtils;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.core.util.ClinicalDocumentCreator;
import org.eclipse.mdht.uml.cda.core.util.InstanceGenerator;
import org.eclipse.mdht.uml.cda.core.util.ModelStatus;
import org.eclipse.mdht.uml.cda.core.util.RIMModelUtil;
import org.eclipse.mdht.uml.cda.dita.DitaTransformerOptions;
import org.eclipse.mdht.uml.cda.dita.TableGenerator;
import org.eclipse.mdht.uml.cda.dita.TransformAbstract;
import org.eclipse.mdht.uml.cda.dita.internal.Logger;
import org.eclipse.mdht.uml.common.util.NamedElementComparator;
import org.eclipse.mdht.uml.common.util.PropertyComparator;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class TransformClassContent
extends TransformAbstract {
    private InstanceGenerator instanceGenerator;
    private TableGenerator tableGenerator;

    public TransformClassContent(DitaTransformerOptions options) {
        super(options);
        if (Platform.getBundle((String)"org.eclipse.mdht.uml.cda") != null) {
            this.instanceGenerator = new InstanceGenerator();
            this.tableGenerator = new TableGenerator();
        }
    }

    private void appendAggregateRules(PrintWriter writer, Class umlClass) {
        Class parent;
        Package xrefSource = UMLUtil.getTopPackage((Element)umlClass);
        ArrayList<Class> allParents = new ArrayList<Class>((Collection<Class>)umlClass.allParents());
        allParents.add(0, umlClass);
        ArrayList<Property> allProperties = new ArrayList<Property>();
        ArrayList<Property> allAssociations = new ArrayList<Property>();
        ArrayList<Property> allAttributes = new ArrayList<Property>();
        ArrayList<Constraint> allConstraints = new ArrayList<Constraint>();
        ArrayList<Constraint> unprocessedConstraints = new ArrayList<Constraint>();
        HashMap<String, List<Constraint>> constraintMap = new HashMap<String, List<Constraint>>();
        HashMap<Constraint, List<Constraint>> subConstraintMap = new HashMap<Constraint, List<Constraint>>();
        for (Constraint constraint : umlClass.getOwnedRules()) {
            unprocessedConstraints.add(constraint);
            if (CDAProfileUtil.getLogicalConstraint((Constraint)constraint) != null) continue;
            for (Element element : constraint.getConstrainedElements()) {
                List<Object> rules;
                if (element instanceof Property) {
                    String name = ((Property)element).getName();
                    rules = (ArrayList<Constraint>)constraintMap.get(name);
                    if (rules == null) {
                        rules = new ArrayList<Constraint>();
                        constraintMap.put(name, rules);
                    }
                    rules.add(constraint);
                    continue;
                }
                if (!(element instanceof Constraint)) continue;
                Constraint subConstraint = (Constraint)element;
                rules = (List)subConstraintMap.get(subConstraint);
                if (rules == null) {
                    rules = new ArrayList();
                    subConstraintMap.put(subConstraint, rules);
                }
                rules.add(constraint);
            }
        }
        int i = allParents.size() - 1;
        while (i >= 0) {
            Class parent2 = (Class)allParents.get(i);
            for (Property property : parent2.getOwnedAttributes()) {
                if (property.getAssociation() != null) {
                    allAssociations.add(property);
                    continue;
                }
                int index = this.findProperty(allProperties, property.getName());
                if (index >= 0) {
                    allProperties.set(index, property);
                    continue;
                }
                allProperties.add(property);
            }
            for (Constraint constraint : parent2.getOwnedRules()) {
                LogicalConstraint logicConstraint = CDAProfileUtil.getLogicalConstraint((Constraint)constraint);
                if (logicConstraint == null) continue;
                for (Element constrainedElement : constraint.getConstrainedElements()) {
                    if (!(constrainedElement instanceof Property)) continue;
                    Property property = (Property)constrainedElement;
                    String validation = CDAModelUtil.getValidationKeyword((Element)constrainedElement);
                    if (validation == null && property.getAssociation() != null) {
                        validation = CDAModelUtil.getValidationKeyword((Element)property.getAssociation());
                    }
                    if (validation != null) continue;
                    allProperties.remove(constrainedElement);
                    allAttributes.remove(constrainedElement);
                }
            }
            --i;
        }
        Iterator propertyIterator = allProperties.iterator();
        while (propertyIterator.hasNext()) {
            Property property = (Property)propertyIterator.next();
            if (!CDAModelUtil.isCDAModel((Element)property) || property.getLower() != 0) continue;
            propertyIterator.remove();
        }
        Iterator associationIterator = allAssociations.iterator();
        while (associationIterator.hasNext()) {
            Property property;
            property = (Property)associationIterator.next();
            if (!CDAModelUtil.isCDAModel((Element)property) || property.getLower() != 0) continue;
            associationIterator.remove();
        }
        ArrayList<Classifier> endTypes = new ArrayList<Classifier>();
        for (Property property : allAssociations) {
            endTypes.add((Classifier)property.getType());
        }
        int index = 0;
        while (index < allAssociations.size()) {
            Classifier classifier = (Classifier)endTypes.get(index);
            boolean hasSubclass = false;
            EList specializations = classifier.getTargetDirectedRelationships(UMLPackage.Literals.GENERALIZATION);
            for (DirectedRelationship relationship : specializations) {
                Classifier specific = ((Generalization)relationship).getSpecific();
                if (!endTypes.contains(specific)) continue;
                hasSubclass = true;
                break;
            }
            if (!hasSubclass) {
                allProperties.add((Property)allAssociations.get(index));
            }
            ++index;
        }
        int i2 = allParents.size() - 1;
        while (i2 >= 0) {
            parent = (Class)allParents.get(i2);
            if (!CDAModelUtil.isCDAModel((Element)parent)) {
                for (Constraint constraint : parent.getOwnedRules()) {
                    allConstraints.add(constraint);
                }
            }
            --i2;
        }
        writer.println("<ol id=\"aggregate\">");
        i2 = allParents.size() - 1;
        while (i2 > 0) {
            String message;
            parent = (Class)allParents.get(i2);
            if (!(RIMModelUtil.isRIMModel((Element)parent) || CDAModelUtil.isCDAModel((Element)parent) || CDAModelUtil.isDatatypeModel((Element)parent) || (message = CDAModelUtil.computeGeneralizationConformanceMessage((Class)parent, (boolean)true, (Package)xrefSource)).length() <= 0)) {
                writer.println("<li>" + message + "</li>");
            }
            --i2;
        }
        for (Property property : allProperties) {
            if (!CDAModelUtil.isXMLAttribute((Property)property)) continue;
            allAttributes.add(property);
        }
        allProperties.removeAll(allAttributes);
        Collections.sort(allAttributes, new NamedElementComparator());
        for (Property property : allAttributes) {
            writer.println("<li>" + CDAModelUtil.computeConformanceMessage((Property)property, (boolean)true));
            this.appendPropertyRules(writer, property, constraintMap, subConstraintMap, unprocessedConstraints);
            this.appendPropertyComments(writer, property);
            writer.println("</li>");
        }
        for (Property property : allProperties) {
            writer.println("<li>" + CDAModelUtil.computeConformanceMessage((Property)property, (boolean)true));
            this.appendPropertyRules(writer, property, constraintMap, subConstraintMap, unprocessedConstraints);
            if (!(property.getType().getOwner() instanceof Class)) {
                this.appendPropertyComments(writer, property);
            }
            writer.println("</li>");
        }
        for (Constraint constraint : allConstraints) {
            writer.println("<li>" + CDAModelUtil.computeConformanceMessage((Constraint)constraint, (boolean)true) + "</li>");
        }
        if (allAttributes.isEmpty() && allProperties.isEmpty() && allConstraints.isEmpty()) {
            writer.println("<li></li>");
        }
        writer.println("</ol>");
    }

    private void appendBody(PrintWriter writer, Class umlClass) {
        String cdaClassName;
        writer.println("<body>");
        this.appendKnownSubclasses(writer, umlClass);
        this.appendClassDocumentation(writer, umlClass);
        this.appendConformanceRules(writer, umlClass);
        this.appendAggregateRules(writer, umlClass);
        this.appendTable(writer, umlClass);
        this.appendExample(writer, umlClass);
        this.appendChanges(writer, umlClass);
        writer.println("<p><ph id=\"classformalname\">" + TransformAbstract.getPublicationName((NamedElement)umlClass) + "</ph></p>");
        Class cdaClass = CDAModelUtil.getCDAClass((Classifier)umlClass);
        String string = cdaClassName = cdaClass != null ? cdaClass.getName() : "MISSING_CDA_CLASS";
        if (cdaClass != null) {
            writer.print("<p id=\"shortdesc\">");
            if (!umlClass.equals(cdaClass)) {
                writer.print("[" + ClinicalDocumentCreator.withoutDigits((String)cdaClassName) + ": templateId <tt>" + CDAModelUtil.getTemplateId((Class)umlClass) + "</tt>]");
            }
            writer.println("</p>");
        }
        writer.println("</body>");
        writer.println("</topic>");
    }

    private void appendKnownSubclasses(PrintWriter writer, Class umlClass) {
        writer.println("<section id=\"knownSubclasses\">");
        List subclasses = UMLUtil.getSpecializations((Classifier)umlClass);
        if (subclasses.size() > 0) {
            writer.print("<p>Known Subclasses: ");
            Iterator iterator = subclasses.iterator();
            while (iterator.hasNext()) {
                Classifier subclass = (Classifier)iterator.next();
                if (!(subclass instanceof Class) || subclass.getOwner() instanceof Class) continue;
                Package xrefSource = UMLUtil.getTopPackage((Element)subclass);
                String xref = CDAModelUtil.computeXref((Element)xrefSource, (Classifier)subclass);
                String format = xref != null && xref.endsWith(".html") ? "format=\"html\" " : "";
                writer.append("<xref " + format + "href=\"" + xref + "\">");
                writer.append(TransformAbstract.getPublicationName((NamedElement)subclass));
                writer.append("</xref>");
                if (!iterator.hasNext()) continue;
                writer.print(", ");
            }
            writer.println("</p>");
        }
        writer.println("</section>");
    }

    private void appendClassDocumentation(PrintWriter writer, Class umlClass) {
        writer.println("<section id=\"description\">");
        for (Comment comment : umlClass.getOwnedComments()) {
            String body = CDAModelUtil.fixNonXMLCharacters((String)comment.getBody().trim());
            writer.println("<p>" + body + "</p>");
        }
        writer.println("</section>");
    }

    private void appendConformanceRules(PrintWriter writer, Class umlClass) {
        writer.println("<ol id=\"conformance\">");
        Property templateIdProperty = null;
        if (this.transformerOptions.isPrintAssigningAuthorityName()) {
            templateIdProperty = CDACommonUtils.createTemplateIdProperty((Class)umlClass);
        }
        if (templateIdProperty != null) {
            writer.println("<li>" + CDAModelUtil.computeConformanceMessage((Property)templateIdProperty, (boolean)true) + "</li>");
            umlClass.getOwnedAttributes().remove((Object)templateIdProperty);
        }
        if (CDAModelUtil.getTemplateId((Class)umlClass) != null && templateIdProperty == null) {
            writer.println("<li>" + CDAModelUtil.computeConformanceMessage((Class)umlClass, (boolean)true) + "</li>");
        }
        boolean hasRules = false;
        for (Generalization generalization : umlClass.getGeneralizations()) {
            String message;
            Classifier general = generalization.getGeneral();
            if (RIMModelUtil.isRIMModel((Element)general) || CDAModelUtil.isCDAModel((Element)general) || CDAModelUtil.isDatatypeModel((Element)general) || (message = CDAModelUtil.computeConformanceMessage((Generalization)generalization, (boolean)true)).length() <= 0) continue;
            hasRules = true;
            writer.println("<li>" + message + "</li>");
        }
        ArrayList<Constraint> unprocessedConstraints = new ArrayList<Constraint>();
        HashMap<String, List<Constraint>> constraintMap = new HashMap<String, List<Constraint>>();
        HashMap<Constraint, List<Constraint>> subConstraintMap = new HashMap<Constraint, List<Constraint>>();
        for (Constraint constraint : umlClass.getOwnedRules()) {
            unprocessedConstraints.add(constraint);
            for (Element element : constraint.getConstrainedElements()) {
                List<Object> rules;
                if (CDAProfileUtil.getLogicalConstraint((Constraint)constraint) != null) continue;
                if (element instanceof Property) {
                    if (!CDAModelUtil.hasOwnPDFSection((Property)((Property)element))) {
                        unprocessedConstraints.remove(constraint);
                        continue;
                    }
                    String name = ((Property)element).getName();
                    rules = (List)constraintMap.get(name);
                    if (rules == null) {
                        rules = new ArrayList();
                        constraintMap.put(name, rules);
                    }
                    rules.add(constraint);
                    continue;
                }
                if (!(element instanceof Constraint)) continue;
                Constraint subConstraint = (Constraint)element;
                rules = (ArrayList<Constraint>)subConstraintMap.get(subConstraint);
                if (rules == null) {
                    rules = new ArrayList<Constraint>();
                    subConstraintMap.put(subConstraint, rules);
                }
                rules.add(constraint);
            }
        }
        ArrayList allProperties = new ArrayList(umlClass.getOwnedAttributes());
        ArrayList<Property> allAttributes = new ArrayList<Property>();
        for (Property property : allProperties) {
            if (!CDAModelUtil.isXMLAttribute((Property)property)) continue;
            allAttributes.add(property);
        }
        for (Constraint constraint : umlClass.getOwnedRules()) {
            LogicalConstraint logicConstraint = CDAProfileUtil.getLogicalConstraint((Constraint)constraint);
            if (logicConstraint == null) continue;
            for (Element constrainedElement : constraint.getConstrainedElements()) {
                if (!(constrainedElement instanceof Property)) continue;
                Property property = (Property)constrainedElement;
                String validation = CDAModelUtil.getValidationKeyword((Element)constrainedElement);
                if (validation == null && property.getAssociation() != null) {
                    validation = CDAModelUtil.getValidationKeyword((Element)property.getAssociation());
                }
                if (validation != null) continue;
                allProperties.remove(constrainedElement);
                allAttributes.remove(constrainedElement);
            }
        }
        allProperties.removeAll(allAttributes);
        Collections.sort(allAttributes, new NamedElementComparator());
        for (Property property : allAttributes) {
            if (!CDAModelUtil.hasOwnPDFSection((Property)property)) continue;
            hasRules = true;
            writer.println("<li>" + CDAModelUtil.computeConformanceMessage((Property)property, (boolean)true));
            this.appendPropertyComments(writer, property);
            this.appendPropertyRules(writer, property, constraintMap, subConstraintMap, unprocessedConstraints);
            writer.println("</li>");
        }
        Collections.sort(allProperties, new PropertyComparator());
        for (Property property : allProperties) {
            PrintWriter printWriter;
            StringWriter stringWriter;
            if (!CDAModelUtil.hasOwnPDFSection((Property)property)) continue;
            hasRules = true;
            writer.println("<li>");
            String extendedConformanceMessage = CDAModelUtil.computeConformanceMessage((Property)property, (boolean)true);
            if (!(property.getType().getOwner() instanceof Class)) {
                stringWriter = new StringWriter();
                printWriter = new PrintWriter(stringWriter);
                this.appendPropertyComments(printWriter, property);
                extendedConformanceMessage = String.valueOf(extendedConformanceMessage) + stringWriter.getBuffer().toString();
            }
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            this.appendPropertyRules(printWriter, property, constraintMap, subConstraintMap, unprocessedConstraints);
            extendedConformanceMessage = TransformClassContent.meltOL(extendedConformanceMessage, stringWriter.getBuffer().toString());
            writer.println(extendedConformanceMessage);
            writer.println("</li>");
        }
        for (Constraint constraint : unprocessedConstraints) {
            hasRules = true;
            writer.println("<li>" + CDAModelUtil.computeConformanceMessage((Constraint)constraint, (boolean)true) + "</li>");
        }
        if (!hasRules) {
            writer.println("<li></li>");
        }
        writer.println("</ol>");
    }

    public static String meltOL(String a, String b) {
        if (a.endsWith("</ol>") && b.startsWith("<ol>")) {
            return String.valueOf(a.substring(0, a.length() - "</ol>".length())) + b.substring("<ol>".length());
        }
        return String.valueOf(a) + b;
    }

    private void appendExample(PrintWriter writer, Class umlClass) {
        writer.print("<codeblock id=\"example\" outputclass=\"language-xml\"><![CDATA[");
        if (this.instanceGenerator != null) {
            EObject eObject;
            int exampleDepth = this.transformerOptions.getExampleDepth();
            this.transformerOptions.isIncludeTableView();
            String xmlGeneratorType = this.transformerOptions.getXmlGeneratorType();
            if (xmlGeneratorType == null) {
                xmlGeneratorType = "custom-if-data-present";
            }
            EObject eObject2 = "custom-only".equals(xmlGeneratorType) ? null : (eObject = this.instanceGenerator.createInstance(umlClass, exampleDepth > 0 ? exampleDepth : 2));
            if (eObject == null && !"original-only".equals(xmlGeneratorType) || "custom".equals(xmlGeneratorType) || "custom-if-data-present".equals(xmlGeneratorType)) {
                ArrayList statuses = new ArrayList();
                ClinicalDocumentCreator creator = new ClinicalDocumentCreator(null, umlClass.eResource().getResourceSet(), statuses);
                creator.enableSampleData(true);
                creator.enableSampleDataExpansion(true);
                List props = Collections.emptyList();
                EObject newObject = creator.initializeSnippet(umlClass, props);
                if (newObject == null && eObject == null && !"original".equals(xmlGeneratorType)) {
                    writer.println("Error: Custom XML generator could not create XML sample");
                    for (ModelStatus status : statuses) {
                        writer.println("Error code " + status.getCode() + ": " + status.getMessage());
                    }
                    writer.println("]]></codeblock>");
                    return;
                }
                if (newObject != null && (eObject == null || "custom".equals(xmlGeneratorType) || "custom-if-data-present".equals(xmlGeneratorType) && creator.getSampler().isCustomDataUsed())) {
                    String xml = creator.toXMLString(newObject, umlClass);
                    writer.write(xml);
                    writer.println("]]></codeblock>");
                    for (ModelStatus status : statuses) {
                        writer.println("<!--Error code " + status.getCode() + ": " + status.getMessage() + "-->");
                    }
                    return;
                }
            }
            if (eObject != null) {
                this.instanceGenerator.save(eObject, (Writer)writer);
            } else {
                Logger.log(4, "Error: Missing Runtime Class for UML Class " + umlClass.getQualifiedName());
                writer.print("Error: Missing Runtime Class");
            }
        } else {
            writer.print("TODO: XML document snippet");
        }
        writer.println("]]></codeblock>");
    }

    private void appendHeader(PrintWriter writer, Class umlClass) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<!DOCTYPE topic PUBLIC \"-//OASIS//DTD DITA Topic//EN\" \"topic.dtd\">");
        writer.println("<topic id=\"classId\" xml:lang=\"en-us\">");
        writer.print("<title>");
        writer.print(TransformAbstract.getPublicationName((NamedElement)umlClass));
        writer.print(" - conformance rules");
        writer.println("</title>");
        Class cdaClass = CDAModelUtil.getCDAClass((Classifier)umlClass);
        String prefix = this.getExtensionName(cdaClass);
        String cdaClassName = cdaClass != null ? cdaClass.getName() : "MISSING_CDA_CLASS";
        writer.print("<shortdesc id=\"shortdesc\">");
        if (umlClass.isAbstract()) {
            writer.print("<i>Abstract</i> ");
        }
        if (cdaClass != null && !umlClass.equals(cdaClass)) {
            writer.print("[" + prefix + ClinicalDocumentCreator.withoutDigits((String)cdaClassName) + ": templateId <tt>" + CDAModelUtil.getTemplateId((Class)umlClass) + "</tt>]");
        }
        writer.println("</shortdesc>");
        writer.println("<prolog id=\"prolog\">");
        if (cdaClass != null) {
            writer.println("<metadata><category>" + cdaClassName + "</category></metadata>");
            writer.println("<resourceid id=\"" + CDAModelUtil.getTemplateId((Class)umlClass) + "\"/>");
        }
        writer.println("</prolog>");
    }

    private String getExtensionName(Class cdaClass) {
        String name = CDAModelUtil.getNameSpacePrefix((Class)cdaClass);
        return name == null || name.isEmpty() ? "" : String.valueOf(name) + ":";
    }

    private void appendPropertyComments(PrintWriter writer, Property property) {
        Association association = property.getAssociation();
        if (association != null && association.getOwnedComments().size() > 0) {
            writer.append("<ol>");
            for (Comment comment : association.getOwnedComments()) {
                writer.append("<li><p>");
                writer.append(CDAModelUtil.fixNonXMLCharacters((String)comment.getBody()));
                writer.append("</p></li>");
            }
            writer.append("</ol>");
        }
        if (property.getOwnedComments().size() > 0) {
            for (Comment comment : property.getOwnedComments()) {
                writer.append("<p>");
                writer.append(CDAModelUtil.fixNonXMLCharacters((String)comment.getBody()));
                writer.append("</p>");
            }
        }
    }

    private void appendPropertyRules(PrintWriter writer, Property property, Map<String, List<Constraint>> constraintMap, Map<Constraint, List<Constraint>> subConstraintMap, List<Constraint> unprocessedConstraints) {
        String assocConstraints = "";
        if (property.getAssociation() != null) {
            assocConstraints = CDAModelUtil.computeAssociationConstraints((Property)property, (boolean)true);
        }
        StringBuffer ruleConstraints = new StringBuffer();
        List<Constraint> rules = constraintMap.get(property.getName());
        if (rules != null && !rules.isEmpty()) {
            for (Constraint constraint : rules) {
                unprocessedConstraints.remove(constraint);
                ruleConstraints.append("\n<li>" + CDAModelUtil.computeConformanceMessage((Constraint)constraint, (boolean)true));
                this.appendSubConstraintRules(ruleConstraints, constraint, subConstraintMap, unprocessedConstraints);
                ruleConstraints.append("</li>");
            }
        }
        if (assocConstraints.length() > 0 || ruleConstraints.length() > 0) {
            writer.append("<ol>");
            writer.append(assocConstraints);
            writer.append(ruleConstraints);
            writer.append("</ol>");
        }
    }

    private void appendSubConstraintRules(StringBuffer ruleConstraints, Constraint constraint, Map<Constraint, List<Constraint>> subConstraintMap, List<Constraint> unprocessedConstraints) {
        List<Constraint> subConstraints = subConstraintMap.get(constraint);
        if (subConstraints != null && subConstraints.size() > 0) {
            ruleConstraints.append("<ol>");
            for (Constraint subConstraint : subConstraints) {
                unprocessedConstraints.remove(subConstraint);
                ruleConstraints.append("\n<li>" + CDAModelUtil.computeConformanceMessage((Constraint)subConstraint, (boolean)true));
                this.appendSubConstraintRules(ruleConstraints, subConstraint, subConstraintMap, unprocessedConstraints);
                ruleConstraints.append("</li>");
            }
            ruleConstraints.append("</ol>");
        }
    }

    public Object caseClass(Class umlClass) {
        String normalizedClassName = TransformClassContent.normalizeCodeName(umlClass.getName());
        String pathFolder = "classes";
        IPath filePath = this.transformerOptions.getOutputPath().append(pathFolder).addTrailingSeparator().append("generated").addTrailingSeparator().append("_" + normalizedClassName).addFileExtension("dita");
        return this.writeClassToFile(umlClass, filePath);
    }

    public Object writeClassToFile(Class umlClass, IPath filePath) {
        File file = filePath.toFile();
        try (PrintWriter writer = null;){
            try {
                file.createNewFile();
                writer = new PrintWriter(file);
                this.appendHeader(writer, umlClass);
                this.appendBody(writer, umlClass);
            }
            catch (FileNotFoundException e) {
                Logger.logException(e);
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e1) {
                Logger.logException(e1);
                if (writer != null) {
                    writer.close();
                }
            }
        }
        return umlClass;
    }

    private int findProperty(List<Property> properties, String name) {
        if (name != null) {
            int i = 0;
            while (i < properties.size()) {
                if (name.equals(properties.get(i).getName())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private String modelPrefix(NamedElement element) {
        StringBuffer prefix = new StringBuffer();
        String modelPrefix = CDAModelUtil.getModelPrefix((Element)element);
        if (modelPrefix != null && modelPrefix.length() > 0) {
            prefix.append("[");
            prefix.append(modelPrefix);
            prefix.append("] ");
        }
        return prefix.toString();
    }

    private void appendTable(PrintWriter writer, Class umlClass) {
        if (this.tableGenerator != null) {
            String table = this.tableGenerator.createTable(umlClass);
            if (table != null && table.length() > 0) {
                writer.println(table);
            }
            if ((table = this.tableGenerator.createTable2(umlClass)) != null && table.length() > 0) {
                writer.println(table);
            }
        }
    }

    private void appendChanges(PrintWriter writer, Class umlClass) {
        writer.println("<section id=\"changes\">");
        for (Substitution substitution : umlClass.getSubstitutions()) {
            for (NamedElement ne : substitution.getSuppliers()) {
                if (!(ne instanceof Class)) continue;
                this.appendChangeLog(writer, umlClass, (Class)ne);
            }
        }
        writer.println("</section>");
    }

    private static void composeAllConformanceMessages(Class element, final PrintWriter writer, final boolean markup) {
        final TreeIterator iterator = EcoreUtil.getAllContents(Collections.singletonList(element));
        while (iterator != null && iterator.hasNext()) {
            EObject child = (EObject)iterator.next();
            UMLSwitch<Object> umlSwitch = new UMLSwitch<Object>(){

                public Object caseAssociation(Association association) {
                    iterator.prune();
                    return association;
                }

                public Object caseClass(Class umlClass) {
                    String message = CDAModelUtil.computeConformanceMessage((Class)umlClass, (boolean)markup);
                    writer.println(message);
                    return umlClass;
                }

                public Object caseGeneralization(Generalization generalization) {
                    String message = CDAModelUtil.computeConformanceMessage((Generalization)generalization, (boolean)markup);
                    if (message.length() > 0) {
                        writer.println(message);
                    }
                    return generalization;
                }

                public Object caseProperty(Property property) {
                    String message = CDAModelUtil.computeConformanceMessage((Property)property, (boolean)markup);
                    if (message.length() > 0) {
                        writer.println(message);
                    }
                    return property;
                }

                public Object caseConstraint(Constraint constraint) {
                    String message = CDAModelUtil.computeConformanceMessage((Constraint)constraint, (boolean)markup);
                    if (message.length() > 0) {
                        writer.println(message);
                    }
                    return constraint;
                }
            };
            umlSwitch.doSwitch(child);
        }
    }

    public IStatus appendChanges(PrintWriter writer, InputStream target, InputStream other) {
        String s;
        int j;
        RangeDifference rd;
        LineComparator o;
        LineComparator t;
        IProgressMonitor monitor = null;
        try {
            t = new LineComparator(target);
            o = new LineComparator(other);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        String lineSeparator = System.getProperty("line.separator");
        if (lineSeparator == null) {
            lineSeparator = "\n";
        }
        RangeDifference[] diffs = RangeDifferencer.findRanges(monitor, (IRangeComparator)t, (IRangeComparator)o);
        writer.append("<li>");
        writer.println("<b>Modifications</b>");
        writer.append("</li>");
        int i = 0;
        while (i < diffs.length) {
            rd = diffs[i];
            switch (rd.kind()) {
                case 2: {
                    j = rd.rightStart();
                    while (j < rd.rightEnd()) {
                        s = o.getLine(j);
                        writer.append("<li>");
                        writer.println(s);
                        writer.append("</li>");
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        writer.append("<li>");
        writer.println("<b>Additions</b>");
        writer.append("</li>");
        i = 0;
        while (i < diffs.length) {
            rd = diffs[i];
            switch (rd.kind()) {
                case 3: {
                    j = rd.leftStart();
                    while (j < rd.leftEnd()) {
                        s = t.getLine(j);
                        writer.append("<li>");
                        writer.println(s);
                        writer.append("</li>");
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    void appendChangeLog(PrintWriter writer, Class source, Class substitute) {
        writer.println("<p>");
        writer.println("Change Log from " + CDAModelUtil.getModelPrefix((Element)substitute) + "::" + substitute.getName());
        writer.println("</p>");
        writer.println("<p id=\"" + substitute.getName() + "\" >");
        writer.append("<ol>");
        StringWriter leftsw = new StringWriter();
        PrintWriter leftpw = new PrintWriter(leftsw);
        TransformClassContent.composeAllConformanceMessages(source, leftpw, false);
        StringWriter rightsw = new StringWriter();
        PrintWriter rightpw = new PrintWriter(rightsw);
        TransformClassContent.composeAllConformanceMessages(substitute, rightpw, false);
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(leftsw.getBuffer().toString().getBytes());
        ByteArrayInputStream substitueStream = new ByteArrayInputStream(rightsw.getBuffer().toString().getBytes());
        this.appendChanges(writer, sourceStream, substitueStream);
        writer.append("</ol>");
        writer.println("</p>");
    }

    class LineComparator
    implements IRangeComparator {
        private String[] fLines;

        public LineComparator(InputStream is) throws IOException {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            ArrayList<String> ar = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                ar.add(line);
            }
            this.fLines = ar.toArray(new String[ar.size()]);
        }

        String getLine(int ix) {
            return this.fLines[ix];
        }

        public int getRangeCount() {
            return this.fLines.length;
        }

        public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
            String s1 = this.fLines[thisIndex];
            String s2 = ((LineComparator)other).fLines[otherIndex];
            return s1.equals(s2);
        }

        public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
            return false;
        }
    }
}

