/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.preferences;

import java.util.Locale;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.preferences.Messages;

public class PreferenceSupport {
    public static final String[][] LEGEND_POSITIONS = new String[][]{{Messages.getString("LEFT"), Integer.toString(16384)}, {Messages.getString("RIGHT"), Integer.toString(131072)}, {Messages.getString("TOP"), Integer.toString(128)}, {Messages.getString("BOTTOM"), Integer.toString(1024)}};
    public static final String[][] ORIENTATIONS = new String[][]{{Messages.getString("HORIZONTAL"), Integer.toString(256)}, {Messages.getString("VERTICAL"), Integer.toString(512)}};
    public static final String[][] AXIS_POSITIONS = new String[][]{{Messages.getString("PRIMARY"), IAxis.Position.Primary.toString()}, {Messages.getString("SECONDARY"), IAxis.Position.Secondary.toString()}};
    public static final String[][] LOCALES = new String[][]{{Messages.getString("ENGLISH"), Locale.ENGLISH.getLanguage()}, {Messages.getString("US"), Locale.US.getLanguage()}, {Messages.getString("GERMAN"), Locale.GERMAN.getLanguage()}};
    public static final String[][] LINE_STYLES = new String[][]{{Messages.getString("NONE"), LineStyle.NONE.toString()}, {Messages.getString("SOLID"), LineStyle.SOLID.toString()}, {Messages.getString("DASH"), LineStyle.DASH.toString()}, {Messages.getString("DOT"), LineStyle.DOT.toString()}, {Messages.getString("DASH_DOT"), LineStyle.DASHDOT.toString()}, {Messages.getString("DASH_DOT_DOT"), LineStyle.DASHDOTDOT.toString()}};
    public static final String[][] ANTIALIAS_OPTIONS = new String[][]{{Messages.getString("DEFAULT"), Integer.toString(-1)}, {Messages.getString("ON"), Integer.toString(1)}, {Messages.getString("OFF"), Integer.toString(0)}};
    public static final String[][] SYMBOL_TYPES = new String[][]{{Messages.getString("NONE"), ILineSeries.PlotSymbolType.NONE.toString()}, {Messages.getString("CIRCLE"), ILineSeries.PlotSymbolType.CIRCLE.toString()}, {Messages.getString("CROSS"), ILineSeries.PlotSymbolType.CROSS.toString()}, {Messages.getString("DIAMOND"), ILineSeries.PlotSymbolType.DIAMOND.toString()}, {Messages.getString("INVERTED_TRIANGLE"), ILineSeries.PlotSymbolType.INVERTED_TRIANGLE.toString()}, {Messages.getString("PLUS"), ILineSeries.PlotSymbolType.PLUS.toString()}, {Messages.getString("SQUARE"), ILineSeries.PlotSymbolType.SQUARE.toString()}, {Messages.getString("TRIANGLE"), ILineSeries.PlotSymbolType.TRIANGLE.toString()}, {Messages.getString("EMOJI"), ILineSeries.PlotSymbolType.EMOJI.toString()}};
    public static final String[][] BAR_WIDTH_STYLES = new String[][]{{Messages.getString("FIXED"), IBarSeries.BarWidthStyle.FIXED.toString()}, {Messages.getString("STRETCHED"), IBarSeries.BarWidthStyle.STRETCHED.toString()}};
    public static final String[][] EXTEND_TYPES = new String[][]{{Messages.getString("RELATIVE"), RangeRestriction.ExtendType.RELATIVE.toString()}, {Messages.getString("ABSOLUTE"), RangeRestriction.ExtendType.ABSOLUTE.toString()}};

    private PreferenceSupport() {
    }

    public static boolean isBufferedSelection() {
        boolean bufferedSelection = false;
        IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();
        if (preferenceStore != null) {
            bufferedSelection = preferenceStore.getBoolean("bufferSelection");
        }
        return bufferedSelection;
    }

    public static void setBufferedSelection(boolean active) {
        IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();
        if (preferenceStore != null) {
            preferenceStore.setValue("bufferSelection", active);
        }
    }
}

