/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.remotese.rm;

import java.util.concurrent.CountDownLatch;
import org.eclipse.keyple.plugin.remotese.exception.KeypleRemoteException;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethodTxCallback;
import org.eclipse.keyple.plugin.remotese.transport.DtoSender;
import org.eclipse.keyple.plugin.remotese.transport.model.KeypleDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteMethodTx<T> {
    private static final Logger logger = LoggerFactory.getLogger(RemoteMethodTx.class);
    protected String sessionId;
    protected String nativeReaderName;
    protected String virtualReaderName;
    protected String clientNodeId;
    private T response;
    private KeypleRemoteException remoteException;
    private CountDownLatch lock;
    private RemoteMethodTxCallback<T> callback;
    private DtoSender sender;

    protected RemoteMethodTx(String sessionId, String nativeReaderName, String virtualReaderName, String clientNodeId) {
        this.sessionId = sessionId;
        this.nativeReaderName = nativeReaderName;
        this.virtualReaderName = virtualReaderName;
        this.clientNodeId = clientNodeId;
    }

    void setDto(DtoSender sender) {
        this.sender = sender;
    }

    public abstract T parseResponse(KeypleDto var1) throws KeypleRemoteException;

    public final void asyncGet(RemoteMethodTxCallback<T> callback) throws KeypleRemoteException {
        this.callback = callback;
        this.sender.sendDTO(this.dto());
    }

    public final T get() throws KeypleRemoteException {
        logger.debug("Blocking Get {}", (Object)this.getClass().getCanonicalName());
        final RemoteMethodTx thisInstance = this;
        Thread asyncGet = new Thread(){

            @Override
            public void run() {
                try {
                    RemoteMethodTx.this.asyncGet(new RemoteMethodTxCallback<T>(){

                        @Override
                        public void get(T response, KeypleRemoteException exception) {
                            logger.debug("release lock");
                            RemoteMethodTx.this.lock.countDown();
                        }
                    });
                }
                catch (KeypleRemoteException e) {
                    logger.error("Exception while sending Dto", (Throwable)((Object)e));
                    thisInstance.remoteException = e;
                    RemoteMethodTx.this.lock.countDown();
                }
            }
        };
        try {
            this.lock = new CountDownLatch(1);
            logger.trace("Set callback on RemoteMethodTx {} {}", (Object)this.getClass().getCanonicalName(), (Object)this.hashCode());
            asyncGet.start();
            logger.trace("Lock {}, {}", (Object)this.getClass().getCanonicalName(), (Object)this.hashCode());
            this.lock.await();
            logger.trace("Unlock {}, {}", (Object)this.getClass().getCanonicalName(), (Object)this.hashCode());
            if (this.remoteException != null) {
                throw this.remoteException;
            }
            return this.response;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new IllegalStateException("Thread locking in blocking transmitSet has encountered an exception", e);
        }
    }

    void asyncSetResponse(KeypleDto keypleDto) {
        try {
            this.response = this.parseResponse(keypleDto);
            this.callback.get(this.response, null);
        }
        catch (KeypleRemoteException e) {
            this.remoteException = e;
            this.callback.get(null, e);
        }
    }

    public abstract KeypleDto dto();
}

