/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.frame;

import jdk.incubator.http.internal.common.ByteBufferReference;
import jdk.incubator.http.internal.frame.HeaderFrame;

public class PushPromiseFrame
extends HeaderFrame {
    private int padLength;
    private final int promisedStream;
    public static final int TYPE = 5;
    public static final int END_HEADERS = 4;
    public static final int PADDED = 8;

    public PushPromiseFrame(int n, int n2, int n3, ByteBufferReference[] byteBufferReferenceArray, int n4) {
        super(n, n2, byteBufferReferenceArray);
        this.promisedStream = n3;
        if (n4 > 0) {
            this.setPadLength(n4);
        }
    }

    @Override
    public int type() {
        return 5;
    }

    @Override
    int length() {
        return this.headerLength + ((this.flags & 8) != 0 ? 5 : 4);
    }

    @Override
    public String toString() {
        return super.toString() + " promisedStreamid: " + this.promisedStream + " headerLength: " + this.headerLength;
    }

    @Override
    public String flagAsString(int n) {
        switch (n) {
            case 8: {
                return "PADDED";
            }
            case 4: {
                return "END_HEADERS";
            }
        }
        return super.flagAsString(n);
    }

    public void setPadLength(int n) {
        this.padLength = n;
        this.flags |= 8;
    }

    public int getPadLength() {
        return this.padLength;
    }

    public int getPromisedStream() {
        return this.promisedStream;
    }

    @Override
    public boolean endHeaders() {
        return this.getFlag(4);
    }
}

