/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.common;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import jdk.incubator.http.internal.common.ByteBufferReference;

public class ByteBufferPool {
    private final Queue<ByteBuffer> pool = new ConcurrentLinkedQueue<ByteBuffer>();

    public ByteBufferReference get(int n) {
        ByteBuffer byteBuffer;
        while ((byteBuffer = this.pool.poll()) != null) {
            if (byteBuffer.capacity() < n) continue;
            return ByteBufferReference.of(byteBuffer, this);
        }
        return ByteBufferReference.of(ByteBuffer.allocate(n), this);
    }

    public void release(ByteBuffer byteBuffer) {
        byteBuffer.clear();
        this.pool.offer(byteBuffer);
    }
}

