/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import jdk.incubator.http.HeaderFilter;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.MultiExchange;
import jdk.incubator.http.Response;
import jdk.incubator.http.internal.common.Utils;

class RedirectFilter
implements HeaderFilter {
    HttpRequestImpl request;
    HttpClientImpl client;
    HttpClient.Redirect policy;
    String method;
    MultiExchange<?, ?> exchange;
    static final int DEFAULT_MAX_REDIRECTS = 5;
    URI uri;
    static final int max_redirects = Utils.getIntegerNetProperty("jdk.httpclient.redirects.retrylimit", 5);

    RedirectFilter() {
    }

    @Override
    public synchronized void request(HttpRequestImpl httpRequestImpl, MultiExchange<?, ?> multiExchange) throws IOException {
        this.request = httpRequestImpl;
        this.client = multiExchange.client();
        this.policy = this.client.followRedirects();
        this.method = httpRequestImpl.method();
        this.uri = httpRequestImpl.uri();
        this.exchange = multiExchange;
    }

    @Override
    public synchronized HttpRequestImpl response(Response response) throws IOException {
        return this.handleResponse(response);
    }

    private HttpRequestImpl handleResponse(Response response) {
        int n = response.statusCode();
        if (n == 200 || this.policy == HttpClient.Redirect.NEVER) {
            return null;
        }
        if (n >= 300 && n <= 399) {
            URI uRI = this.getRedirectedURI(response.headers());
            if (this.canRedirect(uRI) && ++this.exchange.numberOfRedirects < max_redirects) {
                return new HttpRequestImpl(uRI, this.method, this.request);
            }
            return null;
        }
        return null;
    }

    private URI getRedirectedURI(HttpHeaders httpHeaders) {
        String string2 = httpHeaders.firstValue("Location").orElse("Not present");
        URI uRI = httpHeaders.firstValue("Location").map(string -> URI.create(string)).orElseThrow(() -> new UncheckedIOException(new IOException("Invalid redirection")));
        uRI = this.uri.resolve(uRI);
        return uRI;
    }

    private boolean canRedirect(URI uRI) {
        String string = uRI.getScheme();
        String string2 = this.uri.getScheme();
        switch (this.policy) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case SECURE: {
                return string.equalsIgnoreCase("https");
            }
            case SAME_PROTOCOL: {
                return string.equalsIgnoreCase(string2);
            }
        }
        throw new InternalError();
    }
}

