package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.uml.derivedfeatures.StructuredClassifierPartMatch;
import org.eclipse.incquery.uml.derivedfeatures.util.StructuredClassifierPartQuerySpecification;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;

/**
 * Generated pattern matcher API of the org.eclipse.incquery.uml.derivedfeatures.structuredClassifierPart pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link StructuredClassifierPartMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * (ownedAttribute-{@literal >}select(isComposite)-{@literal >}asSet())
 * 
 * {@literal @}Surrogate(feature = "part")
 * {@literal @}QueryExplorer(checked = false)
 * pattern structuredClassifierPart(structuredClassifier: StructuredClassifier, part: Property) {
 *     StructuredClassifier.ownedAttribute(structuredClassifier, part);
 *     find propertyIsComposite(part, true);
 * }
 * </pre></code>
 * 
 * @see StructuredClassifierPartMatch
 * @see StructuredClassifierPartProcessor
 * @see StructuredClassifierPartQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class StructuredClassifierPartMatcher extends BaseMatcher<StructuredClassifierPartMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static StructuredClassifierPartMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    StructuredClassifierPartMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new StructuredClassifierPartMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_STRUCTUREDCLASSIFIER = 0;
  
  private final static int POSITION_PART = 1;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(StructuredClassifierPartMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public StructuredClassifierPartMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public StructuredClassifierPartMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pStructuredClassifier the fixed value of pattern parameter structuredClassifier, or null if not bound.
   * @param pPart the fixed value of pattern parameter part, or null if not bound.
   * @return matches represented as a StructuredClassifierPartMatch object.
   * 
   */
  public Collection<StructuredClassifierPartMatch> getAllMatches(final StructuredClassifier pStructuredClassifier, final Property pPart) {
    return rawGetAllMatches(new Object[]{pStructuredClassifier, pPart});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pStructuredClassifier the fixed value of pattern parameter structuredClassifier, or null if not bound.
   * @param pPart the fixed value of pattern parameter part, or null if not bound.
   * @return a match represented as a StructuredClassifierPartMatch object, or null if no match is found.
   * 
   */
  public StructuredClassifierPartMatch getOneArbitraryMatch(final StructuredClassifier pStructuredClassifier, final Property pPart) {
    return rawGetOneArbitraryMatch(new Object[]{pStructuredClassifier, pPart});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pStructuredClassifier the fixed value of pattern parameter structuredClassifier, or null if not bound.
   * @param pPart the fixed value of pattern parameter part, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final StructuredClassifier pStructuredClassifier, final Property pPart) {
    return rawHasMatch(new Object[]{pStructuredClassifier, pPart});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pStructuredClassifier the fixed value of pattern parameter structuredClassifier, or null if not bound.
   * @param pPart the fixed value of pattern parameter part, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final StructuredClassifier pStructuredClassifier, final Property pPart) {
    return rawCountMatches(new Object[]{pStructuredClassifier, pPart});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pStructuredClassifier the fixed value of pattern parameter structuredClassifier, or null if not bound.
   * @param pPart the fixed value of pattern parameter part, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final StructuredClassifier pStructuredClassifier, final Property pPart, final IMatchProcessor<? super StructuredClassifierPartMatch> processor) {
    rawForEachMatch(new Object[]{pStructuredClassifier, pPart}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pStructuredClassifier the fixed value of pattern parameter structuredClassifier, or null if not bound.
   * @param pPart the fixed value of pattern parameter part, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final StructuredClassifier pStructuredClassifier, final Property pPart, final IMatchProcessor<? super StructuredClassifierPartMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pStructuredClassifier, pPart}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pStructuredClassifier the fixed value of pattern parameter structuredClassifier, or null if not bound.
   * @param pPart the fixed value of pattern parameter part, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public StructuredClassifierPartMatch newMatch(final StructuredClassifier pStructuredClassifier, final Property pPart) {
    return StructuredClassifierPartMatch.newMatch(pStructuredClassifier, pPart);
  }
  
  /**
   * Retrieve the set of values that occur in matches for structuredClassifier.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<StructuredClassifier> rawAccumulateAllValuesOfstructuredClassifier(final Object[] parameters) {
    Set<StructuredClassifier> results = new HashSet<StructuredClassifier>();
    rawAccumulateAllValues(POSITION_STRUCTUREDCLASSIFIER, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for structuredClassifier.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<StructuredClassifier> getAllValuesOfstructuredClassifier() {
    return rawAccumulateAllValuesOfstructuredClassifier(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for structuredClassifier.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<StructuredClassifier> getAllValuesOfstructuredClassifier(final StructuredClassifierPartMatch partialMatch) {
    return rawAccumulateAllValuesOfstructuredClassifier(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for structuredClassifier.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<StructuredClassifier> getAllValuesOfstructuredClassifier(final Property pPart) {
    return rawAccumulateAllValuesOfstructuredClassifier(new Object[]{
    null, 
    pPart
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for part.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Property> rawAccumulateAllValuesOfpart(final Object[] parameters) {
    Set<Property> results = new HashSet<Property>();
    rawAccumulateAllValues(POSITION_PART, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for part.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Property> getAllValuesOfpart() {
    return rawAccumulateAllValuesOfpart(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for part.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Property> getAllValuesOfpart(final StructuredClassifierPartMatch partialMatch) {
    return rawAccumulateAllValuesOfpart(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for part.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Property> getAllValuesOfpart(final StructuredClassifier pStructuredClassifier) {
    return rawAccumulateAllValuesOfpart(new Object[]{
    pStructuredClassifier, 
    null
    });
  }
  
  @Override
  protected StructuredClassifierPartMatch tupleToMatch(final Tuple t) {
    try {
    	return StructuredClassifierPartMatch.newMatch((org.eclipse.uml2.uml.StructuredClassifier) t.get(POSITION_STRUCTUREDCLASSIFIER), (org.eclipse.uml2.uml.Property) t.get(POSITION_PART));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected StructuredClassifierPartMatch arrayToMatch(final Object[] match) {
    try {
    	return StructuredClassifierPartMatch.newMatch((org.eclipse.uml2.uml.StructuredClassifier) match[POSITION_STRUCTUREDCLASSIFIER], (org.eclipse.uml2.uml.Property) match[POSITION_PART]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected StructuredClassifierPartMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return StructuredClassifierPartMatch.newMutableMatch((org.eclipse.uml2.uml.StructuredClassifier) match[POSITION_STRUCTUREDCLASSIFIER], (org.eclipse.uml2.uml.Property) match[POSITION_PART]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<StructuredClassifierPartMatcher> querySpecification() throws IncQueryException {
    return StructuredClassifierPartQuerySpecification.instance();
  }
}
