/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewmodel.core;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.api.GenericPatternMatch;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.evm.api.ExecutionSchema;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.event.ActivationState;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.specific.Jobs;
import org.eclipse.incquery.runtime.evm.specific.Rules;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.viewmodel.traceablilty.generic.AbstractQuerySpecificationDescriptor;
import org.eclipse.incquery.viewmodel.traceablilty.generic.GenericReferencedQuerySpecification;
import org.eclipse.incquery.viewmodel.traceablilty.generic.GenericTracedQuerySpecification;

public abstract class ViewModelRule {
    private EventFilter<IPatternMatch> filter;
    private boolean isFilterInitialized = false;
    private AbstractQuerySpecificationDescriptor descriptor;
    protected Logger logger = Logger.getLogger(ViewModelRule.class);

    public ViewModelRule(AbstractQuerySpecificationDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public GenericTracedQuerySpecification getTracedSpecification() {
        return this.descriptor.getTracedSpecification();
    }

    public GenericReferencedQuerySpecification getReferencedSpecification() {
        return this.getTracedSpecification().getReferencedSpecification();
    }

    public IQuerySpecification<?> getBaseSpecification() {
        return this.getReferencedSpecification().getBaseSpecification();
    }

    protected Job<GenericPatternMatch> getAppearedJob() {
        return Jobs.newNopJob((ActivationState)IncQueryActivationStateEnum.APPEARED);
    }

    protected Job<GenericPatternMatch> getDisappearedJob() {
        return Jobs.newNopJob((ActivationState)IncQueryActivationStateEnum.DISAPPEARED);
    }

    protected Job<GenericPatternMatch> getUpdatedJob() {
        return Jobs.newNopJob((ActivationState)IncQueryActivationStateEnum.UPDATED);
    }

    public final void createRuleSpecification(ExecutionSchema executionSchema) {
        if (!this.isFilterInitialized) {
            this.filter = this.prepareFilterSuper();
        }
        this.registerReferencedSpecification(executionSchema);
        this.registerTraceabilitySpecification(executionSchema);
    }

    private void registerReferencedSpecification(ExecutionSchema executionSchema) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add(this.getAppearedJob());
        builder.add((Object)Jobs.newNopJob((ActivationState)IncQueryActivationStateEnum.DISAPPEARED));
        builder.add((Object)Jobs.newNopJob((ActivationState)IncQueryActivationStateEnum.UPDATED));
        RuleSpecification ruleSpecification = Rules.newMatcherRuleSpecification((IQuerySpecification)this.getReferencedSpecification(), (Set)builder.build());
        if (this.isFiltered()) {
            executionSchema.addRule(ruleSpecification, this.filter);
        } else {
            executionSchema.addRule(ruleSpecification);
        }
    }

    private void registerTraceabilitySpecification(ExecutionSchema executionSchema) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)Jobs.newNopJob((ActivationState)IncQueryActivationStateEnum.APPEARED));
        builder.add(this.getDisappearedJob());
        builder.add(this.getUpdatedJob());
        RuleSpecification ruleSpecification = Rules.newMatcherRuleSpecification((IQuerySpecification)this.getTracedSpecification(), (Set)builder.build());
        executionSchema.addRule(ruleSpecification);
    }

    private EventFilter<IPatternMatch> prepareFilterSuper() {
        this.isFilterInitialized = true;
        return this.prepareFilter();
    }

    protected abstract EventFilter<IPatternMatch> prepareFilter();

    public void setFilter(EventFilter<IPatternMatch> filter) {
        this.filter = filter;
    }

    public EventFilter<IPatternMatch> getFilter() {
        return this.filter;
    }

    public boolean isFiltered() {
        return this.filter != null;
    }

    public final void initialize(String traceabilityId) throws QueryInitializationException {
        this.descriptor.initialize(traceabilityId);
        this.filter = this.prepareFilter();
    }
}

