package org.eclipse.incquery.viewers.runtime.model.patterns;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2edgeMatch;
import org.eclipse.incquery.viewers.runtime.model.patterns.util.Param2edgeQuerySpecification;
import org.eclipse.incquery.viewmodel.traceability.Trace;

/**
 * Generated pattern matcher API of the org.eclipse.incquery.viewers.runtime.model.patterns.param2edge pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link Param2edgeMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * {@literal @}QueryExplorer(checked = false)
 * pattern param2edge(source, target, trace, edge : Edge) {
 * 	Trace.params(trace, source);
 * 	Trace.params(trace, target);
 * 	Trace.targets(trace, edge);
 * } or {
 * 	Trace.objects(trace, source);
 * 	Trace.params(trace, target);
 * 	Trace.targets(trace, edge);
 * } or {
 * 	Trace.params(trace, source);
 * 	Trace.objects(trace, target);
 * 	Trace.targets(trace, edge);
 * } or {
 * 	Trace.objects(trace, source);
 * 	Trace.objects(trace, target);
 * 	Trace.targets(trace, edge);
 * }
 * </pre></code>
 * 
 * @see Param2edgeMatch
 * @see Param2edgeProcessor
 * @see Param2edgeQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class Param2edgeMatcher extends BaseMatcher<Param2edgeMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static Param2edgeMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    Param2edgeMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new Param2edgeMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_SOURCE = 0;
  
  private final static int POSITION_TARGET = 1;
  
  private final static int POSITION_TRACE = 2;
  
  private final static int POSITION_EDGE = 3;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(Param2edgeMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public Param2edgeMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public Param2edgeMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
   * @return matches represented as a Param2edgeMatch object.
   * 
   */
  public Collection<Param2edgeMatch> getAllMatches(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
    return rawGetAllMatches(new Object[]{pSource, pTarget, pTrace, pEdge});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
   * @return a match represented as a Param2edgeMatch object, or null if no match is found.
   * 
   */
  public Param2edgeMatch getOneArbitraryMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
    return rawGetOneArbitraryMatch(new Object[]{pSource, pTarget, pTrace, pEdge});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
    return rawHasMatch(new Object[]{pSource, pTarget, pTrace, pEdge});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
    return rawCountMatches(new Object[]{pSource, pTarget, pTrace, pEdge});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge, final IMatchProcessor<? super Param2edgeMatch> processor) {
    rawForEachMatch(new Object[]{pSource, pTarget, pTrace, pEdge}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge, final IMatchProcessor<? super Param2edgeMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pSource, pTarget, pTrace, pEdge}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public Param2edgeMatch newMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
    return Param2edgeMatch.newMatch(pSource, pTarget, pTrace, pEdge);
  }
  
  /**
   * Retrieve the set of values that occur in matches for source.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Object> rawAccumulateAllValuesOfsource(final Object[] parameters) {
    Set<Object> results = new HashSet<Object>();
    rawAccumulateAllValues(POSITION_SOURCE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for source.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Object> getAllValuesOfsource() {
    return rawAccumulateAllValuesOfsource(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for source.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Object> getAllValuesOfsource(final Param2edgeMatch partialMatch) {
    return rawAccumulateAllValuesOfsource(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for source.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Object> getAllValuesOfsource(final Object pTarget, final Trace pTrace, final Edge pEdge) {
    return rawAccumulateAllValuesOfsource(new Object[]{
    null, 
    pTarget, 
    pTrace, 
    pEdge
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for target.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Object> rawAccumulateAllValuesOftarget(final Object[] parameters) {
    Set<Object> results = new HashSet<Object>();
    rawAccumulateAllValues(POSITION_TARGET, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for target.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Object> getAllValuesOftarget() {
    return rawAccumulateAllValuesOftarget(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for target.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Object> getAllValuesOftarget(final Param2edgeMatch partialMatch) {
    return rawAccumulateAllValuesOftarget(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for target.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Object> getAllValuesOftarget(final Object pSource, final Trace pTrace, final Edge pEdge) {
    return rawAccumulateAllValuesOftarget(new Object[]{
    pSource, 
    null, 
    pTrace, 
    pEdge
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for trace.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Trace> rawAccumulateAllValuesOftrace(final Object[] parameters) {
    Set<Trace> results = new HashSet<Trace>();
    rawAccumulateAllValues(POSITION_TRACE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for trace.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Trace> getAllValuesOftrace() {
    return rawAccumulateAllValuesOftrace(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for trace.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Trace> getAllValuesOftrace(final Param2edgeMatch partialMatch) {
    return rawAccumulateAllValuesOftrace(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for trace.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Trace> getAllValuesOftrace(final Object pSource, final Object pTarget, final Edge pEdge) {
    return rawAccumulateAllValuesOftrace(new Object[]{
    pSource, 
    pTarget, 
    null, 
    pEdge
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for edge.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Edge> rawAccumulateAllValuesOfedge(final Object[] parameters) {
    Set<Edge> results = new HashSet<Edge>();
    rawAccumulateAllValues(POSITION_EDGE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for edge.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Edge> getAllValuesOfedge() {
    return rawAccumulateAllValuesOfedge(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for edge.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Edge> getAllValuesOfedge(final Param2edgeMatch partialMatch) {
    return rawAccumulateAllValuesOfedge(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for edge.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Edge> getAllValuesOfedge(final Object pSource, final Object pTarget, final Trace pTrace) {
    return rawAccumulateAllValuesOfedge(new Object[]{
    pSource, 
    pTarget, 
    pTrace, 
    null
    });
  }
  
  @Override
  protected Param2edgeMatch tupleToMatch(final Tuple t) {
    try {
    	return Param2edgeMatch.newMatch((java.lang.Object) t.get(POSITION_SOURCE), (java.lang.Object) t.get(POSITION_TARGET), (org.eclipse.incquery.viewmodel.traceability.Trace) t.get(POSITION_TRACE), (org.eclipse.incquery.viewers.runtime.model.Edge) t.get(POSITION_EDGE));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected Param2edgeMatch arrayToMatch(final Object[] match) {
    try {
    	return Param2edgeMatch.newMatch((java.lang.Object) match[POSITION_SOURCE], (java.lang.Object) match[POSITION_TARGET], (org.eclipse.incquery.viewmodel.traceability.Trace) match[POSITION_TRACE], (org.eclipse.incquery.viewers.runtime.model.Edge) match[POSITION_EDGE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected Param2edgeMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return Param2edgeMatch.newMutableMatch((java.lang.Object) match[POSITION_SOURCE], (java.lang.Object) match[POSITION_TARGET], (org.eclipse.incquery.viewmodel.traceability.Trace) match[POSITION_TRACE], (org.eclipse.incquery.viewers.runtime.model.Edge) match[POSITION_EDGE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<Param2edgeMatcher> querySpecification() throws IncQueryException {
    return Param2edgeQuerySpecification.instance();
  }
}
