package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.NamespaceOwnedMemberMatch;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.namespaceOwnedMember pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class NamespaceOwnedMemberProcessor implements IMatchProcessor<NamespaceOwnedMemberMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * 
   */
  public abstract void process(final Namespace pSource, final NamedElement pTarget);
  
  @Override
  public void process(final NamespaceOwnedMemberMatch match) {
    process(match.getSource(), match.getTarget());
  }
}
