package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.ConnectorKindMatch;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorKind;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.connectorKind pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class ConnectorKindProcessor implements IMatchProcessor<ConnectorKindMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSelf the value of pattern parameter self in the currently processed match
   * @param pKind the value of pattern parameter kind in the currently processed match
   * 
   */
  public abstract void process(final Connector pSelf, final ConnectorKind pKind);
  
  @Override
  public void process(final ConnectorKindMatch match) {
    process(match.getSelf(), match.getKind());
  }
}
