/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.api.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternGroup;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.internal.apiimpl.IncQueryEngineImpl;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;

public abstract class BasePatternGroup
implements IPatternGroup {
    @Override
    public void prepare(Notifier emfRoot) throws IncQueryException {
        this.prepare(IncQueryEngine.on(emfRoot));
    }

    @Override
    public void prepare(IncQueryEngine engine) throws IncQueryException {
        try {
            Set<Pattern> patterns = this.getPatterns();
            IncQueryEngineImpl engineImpl = (IncQueryEngineImpl)engine;
            engineImpl.getSanitizer().admit(patterns);
            engineImpl.getReteEngine().buildMatchersCoalesced(patterns);
        }
        catch (RetePatternBuildException e) {
            throw new IncQueryException(e);
        }
    }

    public static Set<Pattern> patterns(Set<IQuerySpecification<?>> querySpecifications) {
        HashSet<Pattern> result = new HashSet<Pattern>();
        for (IQuerySpecification<?> querySpecification : querySpecifications) {
            result.add(querySpecification.getPattern());
        }
        return result;
    }
}

