/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.index;

import java.util.Collection;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.matchers.tuple.TupleMask;
import org.eclipse.incquery.runtime.rete.index.DualInputNode;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;

public class JoinNode
extends DualInputNode {
    public JoinNode(ReteContainer reteContainer, TupleMask complementerSecondaryMask) {
        super(reteContainer, complementerSecondaryMask);
    }

    @Override
    public Tuple calibrate(Tuple primary, Tuple secondary) {
        return this.unify(primary, secondary);
    }

    @Override
    public void notifyUpdate(DualInputNode.Side side, Direction direction, Tuple updateElement, Tuple signature, boolean change) {
        Collection<Tuple> opposites = this.retrieveOpposites(side, signature);
        if (opposites != null) {
            for (Tuple opposite : opposites) {
                this.propagateUpdate(direction, this.unify(side, updateElement, opposite));
            }
        }
        if (this.coincidence) {
            if (opposites != null) {
                for (Tuple opposite : opposites) {
                    if (opposite.equals((Object)updateElement)) continue;
                    this.propagateUpdate(direction, this.unify(opposite, updateElement));
                }
            }
            if (direction == Direction.REVOKE) {
                this.propagateUpdate(direction, this.unify(updateElement, updateElement));
            }
        }
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        this.reteContainer.flushUpdates();
        for (Tuple signature : this.primarySlot.getSignatures()) {
            Collection<Tuple> primaries = this.primarySlot.get(signature);
            Collection<Tuple> opposites = this.secondarySlot.get(signature);
            if (opposites == null) continue;
            for (Tuple ps : primaries) {
                for (Tuple opposite : opposites) {
                    collector.add(this.unify(ps, opposite));
                }
            }
        }
    }
}

