/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.boundary;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.matchers.util.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.boundary.InputConnector;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.Network;
import org.eclipse.incquery.runtime.rete.network.Production;
import org.eclipse.incquery.runtime.rete.network.Receiver;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.network.Supplier;
import org.eclipse.incquery.runtime.rete.remote.Address;
import org.eclipse.incquery.runtime.rete.traceability.CompiledQuery;
import org.eclipse.incquery.runtime.rete.traceability.RecipeTraceInfo;

public class ReteBoundary {
    protected ReteEngine engine;
    protected Network network;
    protected ReteContainer headContainer;
    protected final InputConnector inputConnector;
    protected Map<SubPlan, Address<? extends Supplier>> subplanToAddressMapping;
    protected Map<Address<? extends Receiver>, Set<SubPlan>> parentPlansOfReceiver;

    public ReteContainer getHeadContainer() {
        return this.headContainer;
    }

    public ReteBoundary(ReteEngine engine) {
        this.engine = engine;
        this.network = engine.getReteNet();
        this.headContainer = this.network.getHeadContainer();
        this.inputConnector = this.network.getInputConnector();
        this.parentPlansOfReceiver = CollectionsFactory.getMap();
        this.subplanToAddressMapping = CollectionsFactory.getMap();
    }

    public Collection<? extends RecipeTraceInfo> getAllProductionNodes() {
        return this.engine.getCompiler().getCachedCompiledQueries().values();
    }

    public synchronized RecipeTraceInfo accessProductionTrace(PQuery query) throws QueryProcessingException {
        CompiledQuery compiled = this.engine.getCompiler().getCompiledForm(query);
        return compiled;
    }

    public synchronized Address<? extends Production> accessProductionNode(PQuery query) throws QueryProcessingException {
        RecipeTraceInfo productionTrace = this.accessProductionTrace(query);
        return this.headContainer.getProvisioner().getOrCreateNodeByRecipe(productionTrace);
    }

    private static Direction direction(boolean isInsertion) {
        return isInsertion ? Direction.INSERT : Direction.REVOKE;
    }

    public void notifyEvaluator(Address<? extends Receiver> receiver, Tuple tuple) {
        this.network.sendExternalUpdate(receiver, Direction.INSERT, tuple);
        if (!this.engine.isParallelExecutionEnabled()) {
            this.network.waitForReteTermination();
        }
    }

    @Deprecated
    public void registerParentPlanForReceiver(Address<? extends Receiver> receiver, SubPlan parentPlan) {
        Set parents = this.parentPlansOfReceiver.get(receiver);
        if (parents == null) {
            parents = CollectionsFactory.getSet();
            this.parentPlansOfReceiver.put(receiver, parents);
        }
        parents.add(parentPlan);
    }

    @Deprecated
    public Set<SubPlan> getParentPlansOfReceiver(Address<? extends Receiver> receiver) {
        Set<Object> parents = this.parentPlansOfReceiver.get(receiver);
        if (parents == null) {
            parents = Collections.emptySet();
        }
        return parents;
    }

    public void mapPlanToAddress(SubPlan plan, Address<? extends Supplier> handle) {
        this.subplanToAddressMapping.put(plan, handle);
    }

    public Address<? extends Supplier> getAddress(SubPlan plan) {
        return this.subplanToAddressMapping.get(plan);
    }
}

