/**
 * Copyright (c) 2010-2012, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Mark Czotter - initial API and implementation
 */
package org.eclipse.incquery.patternlanguage.emf.jvmmodel;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.BodyCodeGenerator;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.patternlanguage.emf.specification.SpecificationBuilder;
import org.eclipse.incquery.patternlanguage.emf.types.IEMFTypeProvider;
import org.eclipse.incquery.patternlanguage.emf.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.incquery.patternlanguage.emf.util.IErrorFeedback;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.ParameterReference;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PProblem;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.serializer.impl.Serializer;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.jvmmodel.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * {@link IQuerySpecification} implementation inferrer.
 * 
 * @author Mark Czotter
 */
@SuppressWarnings("all")
public class PatternQuerySpecificationClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil util;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  @Inject
  @Extension
  private IEMFTypeProvider _iEMFTypeProvider;
  
  @Inject
  private IErrorFeedback feedback;
  
  @Inject
  private Serializer serializer;
  
  @Extension
  private JvmTypeReferenceBuilder builder;
  
  @Extension
  private JvmAnnotationReferenceBuilder annBuilder;
  
  /**
   * Infers the {@link IQuerySpecification} implementation class from {@link Pattern}.
   */
  public JvmDeclaredType inferQuerySpecificationClass(final Pattern pattern, final boolean isPrelinkingPhase, final String querySpecificationPackageName, final JvmType matcherClass, final JvmTypeReferenceBuilder builder, final JvmAnnotationReferenceBuilder annBuilder) {
    this.builder = builder;
    this.annBuilder = annBuilder;
    String _querySpecificationClassName = this.util.querySpecificationClassName(pattern);
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      @Override
      public void apply(final JvmGenericType it) {
        it.setPackageName(querySpecificationPackageName);
        CharSequence _javadocQuerySpecificationClass = PatternQuerySpecificationClassInferrer.this._javadocInferrer.javadocQuerySpecificationClass(pattern);
        String _string = _javadocQuerySpecificationClass.toString();
        PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
        it.setFinal(true);
        boolean _isPublic = PatternQuerySpecificationClassInferrer.this.util.isPublic(pattern);
        if (_isPublic) {
          EList<JvmTypeReference> _superTypes = it.getSuperTypes();
          JvmTypeReference _typeRef = PatternQuerySpecificationClassInferrer.this.builder.typeRef(matcherClass);
          JvmTypeReference _typeRef_1 = PatternQuerySpecificationClassInferrer.this.builder.typeRef(BaseGeneratedEMFQuerySpecification.class, _typeRef);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef_1);
        } else {
          EList<JvmTypeReference> _superTypes_1 = it.getSuperTypes();
          JvmTypeReference _typeRef_2 = PatternQuerySpecificationClassInferrer.this.builder.typeRef(IPatternMatch.class);
          JvmTypeReference _typeRef_3 = PatternQuerySpecificationClassInferrer.this.builder.typeRef(matcherClass, _typeRef_2);
          JvmTypeReference _typeRef_4 = PatternQuerySpecificationClassInferrer.this.builder.typeRef(BaseGeneratedEMFQuerySpecification.class, _typeRef_3);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes_1, _typeRef_4);
        }
      }
    };
    final JvmGenericType querySpecificationClass = this._eMFJvmTypesBuilder.toClass(pattern, _querySpecificationClassName, _function);
    return querySpecificationClass;
  }
  
  public void initializePublicSpecification(final JvmDeclaredType querySpecificationClass, final Pattern pattern, final JvmType matcherClass, final JvmType matchClass, final SpecificationBuilder specBuilder) {
    this.inferQuerySpecificationMethods(querySpecificationClass, pattern, matcherClass, matchClass, true);
    this.inferQuerySpecificationInnerClasses(querySpecificationClass, pattern, true, specBuilder);
    this.inferExpressions(querySpecificationClass, pattern);
  }
  
  public void initializePrivateSpecification(final JvmDeclaredType querySpecificationClass, final Pattern pattern, final JvmType matcherClass, final JvmType matchClass, final SpecificationBuilder specBuilder) {
    querySpecificationClass.setVisibility(JvmVisibility.DEFAULT);
    this.inferQuerySpecificationMethods(querySpecificationClass, pattern, matcherClass, matchClass, false);
    this.inferQuerySpecificationInnerClasses(querySpecificationClass, pattern, false, specBuilder);
    this.inferExpressions(querySpecificationClass, pattern);
  }
  
  /**
   * Infers methods for QuerySpecification class based on the input 'pattern'.
   */
  public boolean inferQuerySpecificationMethods(final JvmDeclaredType querySpecificationClass, final Pattern pattern, final JvmType matcherClass, final JvmType matchClass, final boolean isPublic) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = querySpecificationClass.getMembers();
      final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
        @Override
        public void apply(final JvmConstructor it) {
          it.setVisibility(JvmVisibility.PRIVATE);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("super(");
              String _querySpecificationPQueryClassName = PatternQuerySpecificationClassInferrer.this.util.querySpecificationPQueryClassName(pattern);
              _builder.append(_querySpecificationPQueryClassName, "");
              _builder.append(".INSTANCE);");
              _builder.newLineIfNotEmpty();
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmConstructor _constructor = this._eMFJvmTypesBuilder.toConstructor(pattern, _function);
      this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members, _constructor);
      EList<JvmMember> _members_1 = querySpecificationClass.getMembers();
      JvmTypeReference _typeRef = this.builder.typeRef(querySpecificationClass);
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          it.setStatic(true);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          JvmTypeReference _typeRef = PatternQuerySpecificationClassInferrer.this.builder.typeRef(IncQueryException.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef);
          CharSequence _javadocQuerySpecificationInstanceMethod = PatternQuerySpecificationClassInferrer.this._javadocInferrer.javadocQuerySpecificationInstanceMethod(pattern);
          String _string = _javadocQuerySpecificationInstanceMethod.toString();
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("try{");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("return ");
              String _querySpecificationHolderClassName = PatternQuerySpecificationClassInferrer.this.util.querySpecificationHolderClassName(pattern);
              _builder.append(_querySpecificationHolderClassName, "\t");
              _builder.append(".INSTANCE;");
              _builder.newLineIfNotEmpty();
              _builder.append("} catch (");
              _builder.append(ExceptionInInitializerError.class, "");
              _builder.append(" err) {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("throw processInitializerError(err);");
              _builder.newLine();
              _builder.append("}");
              _builder.newLine();
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "instance", _typeRef, _function_1);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method);
      EList<JvmMember> _members_2 = querySpecificationClass.getMembers();
      JvmTypeReference _typeRef_1 = this.builder.typeRef(matcherClass);
      final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PROTECTED);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternQuerySpecificationClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _typeRef = PatternQuerySpecificationClassInferrer.this.builder.typeRef(IncQueryEngine.class);
          JvmFormalParameter _parameter = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "engine", _typeRef);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          JvmTypeReference _typeRef_1 = PatternQuerySpecificationClassInferrer.this.builder.typeRef(IncQueryException.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef_1);
          StringConcatenationClient _xifexpression = null;
          if (isPublic) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return ");
                String _matcherClassName = PatternQuerySpecificationClassInferrer.this.util.matcherClassName(pattern);
                _builder.append(_matcherClassName, "");
                _builder.append(".on(engine);");
              }
            };
            _xifexpression = _client;
          } else {
            StringConcatenationClient _client_1 = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("throw new ");
                _builder.append(UnsupportedOperationException.class, "");
                _builder.append("();");
              }
            };
            _xifexpression = _client_1;
          }
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _xifexpression);
        }
      };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(pattern, "instantiate", _typeRef_1, _function_2);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method_1);
      EList<JvmMember> _members_3 = querySpecificationClass.getMembers();
      JvmTypeReference _xifexpression = null;
      if (isPublic) {
        _xifexpression = this.builder.typeRef(matchClass);
      } else {
        _xifexpression = this.builder.typeRef(IPatternMatch.class);
      }
      final Procedure1<JvmOperation> _function_3 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternQuerySpecificationClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _xifexpression = null;
          if (isPublic) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return ");
                String _matchClassName = PatternQuerySpecificationClassInferrer.this.util.matchClassName(pattern);
                _builder.append(_matchClassName, "");
                _builder.append(".newEmptyMatch();");
              }
            };
            _xifexpression = _client;
          } else {
            StringConcatenationClient _client_1 = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("throw new ");
                _builder.append(UnsupportedOperationException.class, "");
                _builder.append("();");
              }
            };
            _xifexpression = _client_1;
          }
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _xifexpression);
        }
      };
      JvmOperation _method_2 = this._eMFJvmTypesBuilder.toMethod(pattern, "newEmptyMatch", _xifexpression, _function_3);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method_2);
      EList<JvmMember> _members_4 = querySpecificationClass.getMembers();
      JvmTypeReference _xifexpression_1 = null;
      if (isPublic) {
        _xifexpression_1 = this.builder.typeRef(matchClass);
      } else {
        _xifexpression_1 = this.builder.typeRef(IPatternMatch.class);
      }
      final Procedure1<JvmOperation> _function_4 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternQuerySpecificationClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _typeRef = PatternQuerySpecificationClassInferrer.this.builder.typeRef(Object.class);
          JvmTypeReference _addArrayTypeDimension = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.addArrayTypeDimension(_typeRef);
          JvmFormalParameter _parameter = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "parameters", _addArrayTypeDimension);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          it.setVarArgs(true);
          StringConcatenationClient _xifexpression = null;
          if (isPublic) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return ");
                String _matchClassName = PatternQuerySpecificationClassInferrer.this.util.matchClassName(pattern);
                _builder.append(_matchClassName, "");
                _builder.append(".newMatch(");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    _builder.append("(");
                    JvmTypeReference _calculateType = PatternQuerySpecificationClassInferrer.this.util.calculateType(p);
                    String _qualifiedName = _calculateType.getQualifiedName();
                    _builder.append(_qualifiedName, "");
                    _builder.append(") parameters[");
                    EList<Variable> _parameters_1 = pattern.getParameters();
                    int _indexOf = _parameters_1.indexOf(p);
                    _builder.append(_indexOf, "");
                    _builder.append("]");
                  }
                }
                _builder.append(");");
              }
            };
            _xifexpression = _client;
          } else {
            StringConcatenationClient _client_1 = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("throw new ");
                _builder.append(UnsupportedOperationException.class, "");
                _builder.append("();");
              }
            };
            _xifexpression = _client_1;
          }
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _xifexpression);
        }
      };
      JvmOperation _method_3 = this._eMFJvmTypesBuilder.toMethod(pattern, "newMatch", _xifexpression_1, _function_4);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_4, _method_3);
    }
    return _xblockexpression;
  }
  
  public boolean inferPQueryMembers(final JvmDeclaredType pQueryClass, final Pattern pattern, final SpecificationBuilder specBuilder) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = pQueryClass.getMembers();
      JvmTypeReference _typeRef = this.builder.typeRef(pQueryClass);
      final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
        @Override
        public void apply(final JvmField it) {
          it.setFinal(true);
          it.setStatic(true);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("new ");
              String _querySpecificationPQueryClassName = PatternQuerySpecificationClassInferrer.this.util.querySpecificationPQueryClassName(pattern);
              _builder.append(_querySpecificationPQueryClassName, "");
              _builder.append("()");
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setInitializer(it, _client);
        }
      };
      JvmField _field = this._eMFJvmTypesBuilder.toField(pattern, "INSTANCE", _typeRef, _function);
      this._eMFJvmTypesBuilder.<JvmField>operator_add(_members, _field);
      EList<JvmMember> _members_1 = pQueryClass.getMembers();
      JvmTypeReference _typeRef_1 = this.builder.typeRef(String.class);
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternQuerySpecificationClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return \"");
              String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
              _builder.append(_fullyQualifiedName, "");
              _builder.append("\";");
              _builder.newLineIfNotEmpty();
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "getFullyQualifiedName", _typeRef_1, _function_1);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method);
      EList<JvmMember> _members_2 = pQueryClass.getMembers();
      JvmTypeReference _typeRef_2 = this.builder.typeRef(String.class);
      JvmTypeReference _typeRef_3 = this.builder.typeRef(List.class, _typeRef_2);
      final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternQuerySpecificationClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return ");
              _builder.append(Arrays.class, "");
              _builder.append(".asList(");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable param : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(",", "");
                  }
                  _builder.append("\"");
                  String _name = param.getName();
                  _builder.append(_name, "");
                  _builder.append("\"");
                }
              }
              _builder.append(");");
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(pattern, "getParameterNames", _typeRef_3, _function_2);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method_1);
      EList<JvmMember> _members_3 = pQueryClass.getMembers();
      JvmTypeReference _typeRef_4 = this.builder.typeRef(PParameter.class);
      JvmTypeReference _typeRef_5 = this.builder.typeRef(List.class, _typeRef_4);
      final Procedure1<JvmOperation> _function_3 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternQuerySpecificationClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return ");
              _builder.append(Arrays.class, "");
              _builder.append(".asList(");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable param : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(",", "");
                  }
                  CharSequence _parameterInstantiation = PatternQuerySpecificationClassInferrer.this.parameterInstantiation(param);
                  _builder.append(_parameterInstantiation, "");
                }
              }
              _builder.append(");");
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_2 = this._eMFJvmTypesBuilder.toMethod(pattern, "getParameters", _typeRef_5, _function_3);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method_2);
      EList<JvmMember> _members_4 = pQueryClass.getMembers();
      JvmTypeReference _typeRef_6 = this.builder.typeRef(PBody.class);
      JvmTypeReference _typeRef_7 = this.builder.typeRef(Set.class, _typeRef_6);
      final Procedure1<JvmOperation> _function_4 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternQuerySpecificationClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          JvmTypeReference _typeRef = PatternQuerySpecificationClassInferrer.this.builder.typeRef(QueryInitializationException.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef);
          try {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(Set.class, "");
                _builder.append("<");
                _builder.append(PBody.class, "");
                _builder.append("> bodies = ");
                _builder.append(Sets.class, "");
                _builder.append(".newLinkedHashSet();");
                _builder.newLineIfNotEmpty();
                _builder.append("try {");
                _builder.newLine();
                _builder.append("\t");
                StringConcatenationClient _inferBodies = PatternQuerySpecificationClassInferrer.this.inferBodies(pattern);
                _builder.append(_inferBodies, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                StringConcatenationClient _inferAnnotations = PatternQuerySpecificationClassInferrer.this.inferAnnotations(pattern);
                _builder.append(_inferAnnotations, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("// to silence compiler error");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("if (false) throw new IncQueryException(\"Never\", \"happens\");");
                _builder.newLine();
                _builder.append("} catch (");
                _builder.append(IncQueryException.class, "");
                _builder.append(" ex) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("throw processDependencyException(ex);");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.append("return bodies;");
                _builder.newLine();
              }
            };
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
          } catch (final Throwable _t) {
            if (_t instanceof Exception) {
              final Exception e = (Exception)_t;
              StringConcatenationClient _client_1 = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append("addError(new ");
                  _builder.append(PProblem.class, "");
                  _builder.append("(\"Inconsistent pattern definition threw exception ");
                  Class<? extends Exception> _class = e.getClass();
                  String _simpleName = _class.getSimpleName();
                  _builder.append(_simpleName, "");
                  _builder.append("  with message: ");
                  String _message = e.getMessage();
                  String _escapeToQuotedString = PatternQuerySpecificationClassInferrer.this.util.escapeToQuotedString(_message);
                  _builder.append(_escapeToQuotedString, "");
                  _builder.append("\"));");
                  _builder.newLineIfNotEmpty();
                  _builder.append("return bodies;");
                  _builder.newLine();
                }
              };
              PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client_1);
            } else {
              throw Exceptions.sneakyThrow(_t);
            }
          }
        }
      };
      JvmOperation _method_3 = this._eMFJvmTypesBuilder.toMethod(pattern, "doGetContainedBodies", _typeRef_7, _function_4);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_4, _method_3);
    }
    return _xblockexpression;
  }
  
  public StringConcatenationClient inferBodies(final Pattern pattern) throws IllegalStateException {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          EList<PatternBody> _bodies = pattern.getBodies();
          for(final PatternBody body : _bodies) {
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("PBody body = new PBody(this);");
            _builder.newLine();
            _builder.append("\t");
            BodyCodeGenerator _bodyCodeGenerator = new BodyCodeGenerator(pattern, body, PatternQuerySpecificationClassInferrer.this.util, PatternQuerySpecificationClassInferrer.this.feedback, PatternQuerySpecificationClassInferrer.this.serializer);
            _builder.append(_bodyCodeGenerator, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("bodies.add(body);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
          }
        }
      }
    };
    return _client;
  }
  
  /**
   * Infers inner class for QuerySpecification class based on the input 'pattern'.
   */
  public boolean inferQuerySpecificationInnerClasses(final JvmDeclaredType querySpecificationClass, final Pattern pattern, final boolean isPublic, final SpecificationBuilder specBuilder) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = querySpecificationClass.getMembers();
      String _querySpecificationHolderClassName = this.util.querySpecificationHolderClassName(pattern);
      final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
        @Override
        public void apply(final JvmGenericType it) {
          it.setVisibility(JvmVisibility.PRIVATE);
          it.setStatic(true);
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("Inner class allowing the singleton instance of {@link ");
          String _querySpecificationClassName = PatternQuerySpecificationClassInferrer.this.util.querySpecificationClassName(pattern);
          _builder.append(_querySpecificationClassName, "");
          _builder.append("} to be created ");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("<b>not</b> at the class load time of the outer class, ");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("but rather at the first call to {@link ");
          String _querySpecificationClassName_1 = PatternQuerySpecificationClassInferrer.this.util.querySpecificationClassName(pattern);
          _builder.append(_querySpecificationClassName_1, "\t");
          _builder.append("#instance()}.");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("<p> This workaround is required e.g. to support recursion.");
          _builder.newLine();
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _builder.toString());
          EList<JvmMember> _members = it.getMembers();
          JvmTypeReference _typeRef = PatternQuerySpecificationClassInferrer.this.builder.typeRef(querySpecificationClass);
          final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
            @Override
            public void apply(final JvmField it) {
              it.setFinal(true);
              it.setStatic(true);
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append("new ");
                  String _querySpecificationClassName = PatternQuerySpecificationClassInferrer.this.util.querySpecificationClassName(pattern);
                  _builder.append(_querySpecificationClassName, "");
                  _builder.append("()");
                }
              };
              PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setInitializer(it, _client);
            }
          };
          JvmField _field = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toField(pattern, "INSTANCE", _typeRef, _function);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmField>operator_add(_members, _field);
          EList<JvmMember> _members_1 = it.getMembers();
          JvmTypeReference _typeRef_1 = PatternQuerySpecificationClassInferrer.this.builder.typeRef(Object.class);
          final Procedure1<JvmField> _function_1 = new Procedure1<JvmField>() {
            @Override
            public void apply(final JvmField it) {
              it.setFinal(true);
              it.setStatic(true);
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append("ensureInitialized()");
                }
              };
              PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setInitializer(it, _client);
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.");
              _builder.newLine();
              _builder.append("This initialization order is required to support indirect recursion.");
              _builder.newLine();
              _builder.newLine();
              _builder.append("<p> The static initializer is defined using a helper field to work around limitations of the code generator.");
              _builder.newLine();
              PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _builder.toString());
            }
          };
          JvmField _field_1 = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toField(pattern, "STATIC_INITIALIZER", _typeRef_1, _function_1);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmField>operator_add(_members_1, _field_1);
          EList<JvmMember> _members_2 = it.getMembers();
          JvmTypeReference _typeRef_2 = PatternQuerySpecificationClassInferrer.this.builder.typeRef(Object.class);
          final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
            @Override
            public void apply(final JvmOperation it) {
              it.setVisibility(JvmVisibility.PUBLIC);
              it.setStatic(true);
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append("INSTANCE.ensureInitializedInternalSneaky();");
                  _builder.newLine();
                  _builder.append("return null;\t\t\t\t\t");
                  _builder.newLine();
                }
              };
              PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
            }
          };
          JvmOperation _method = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toMethod(pattern, "ensureInitialized", _typeRef_2, _function_2);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method);
        }
      };
      JvmGenericType _class = this._eMFJvmTypesBuilder.toClass(pattern, _querySpecificationHolderClassName, _function);
      this._eMFJvmTypesBuilder.<JvmGenericType>operator_add(_members, _class);
      EList<JvmMember> _members_1 = querySpecificationClass.getMembers();
      String _querySpecificationPQueryClassName = this.util.querySpecificationPQueryClassName(pattern);
      final Procedure1<JvmGenericType> _function_1 = new Procedure1<JvmGenericType>() {
        @Override
        public void apply(final JvmGenericType it) {
          it.setVisibility(JvmVisibility.PRIVATE);
          it.setStatic(true);
          EList<JvmTypeReference> _superTypes = it.getSuperTypes();
          JvmTypeReference _typeRef = PatternQuerySpecificationClassInferrer.this.builder.typeRef(BaseGeneratedEMFPQuery.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef);
          PatternQuerySpecificationClassInferrer.this.inferPQueryMembers(it, pattern, specBuilder);
        }
      };
      JvmGenericType _class_1 = this._eMFJvmTypesBuilder.toClass(pattern, _querySpecificationPQueryClassName, _function_1);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmGenericType>operator_add(_members_1, _class_1);
    }
    return _xblockexpression;
  }
  
  public void inferExpressions(final JvmDeclaredType querySpecificationClass, final Pattern pattern) {
    EList<PatternBody> _bodies = pattern.getBodies();
    final Function1<PatternBody, Collection<XExpression>> _function = new Function1<PatternBody, Collection<XExpression>>() {
      @Override
      public Collection<XExpression> apply(final PatternBody it) {
        return CorePatternLanguageHelper.getAllTopLevelXBaseExpressions(it);
      }
    };
    List<Collection<XExpression>> _map = ListExtensions.<PatternBody, Collection<XExpression>>map(_bodies, _function);
    Iterable<XExpression> _flatten = Iterables.<XExpression>concat(_map);
    final Procedure1<XExpression> _function_1 = new Procedure1<XExpression>() {
      @Override
      public void apply(final XExpression ex) {
        EList<JvmMember> _members = querySpecificationClass.getMembers();
        String _expressionMethodName = PatternQuerySpecificationClassInferrer.this.util.expressionMethodName(ex);
        JvmTypeReference _inferredType = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.inferredType(ex);
        final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            it.setVisibility(JvmVisibility.PRIVATE);
            it.setStatic(true);
            List<Variable> _variables = PatternQuerySpecificationClassInferrer.this.util.variables(ex);
            for (final Variable variable : _variables) {
              {
                String _name = variable.getName();
                JvmTypeReference _calculateType = PatternQuerySpecificationClassInferrer.this.util.calculateType(variable);
                final JvmFormalParameter parameter = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toParameter(variable, _name, _calculateType);
                EList<JvmFormalParameter> _parameters = it.getParameters();
                PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, parameter);
              }
            }
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, ex);
          }
        };
        JvmOperation _method = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toMethod(ex, _expressionMethodName, _inferredType, _function);
        PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
      }
    };
    IterableExtensions.<XExpression>forEach(_flatten, _function_1);
  }
  
  public CharSequence parameterInstantiation(final Variable variable) {
    CharSequence _xblockexpression = null;
    {
      final JvmTypeReference ref = this._iEMFTypeProvider.getVariableType(variable);
      String _xifexpression = null;
      boolean _or = false;
      boolean _equals = Objects.equal(ref, null);
      if (_equals) {
        _or = true;
      } else {
        _or = (ref instanceof JvmUnknownTypeReference);
      }
      if (_or) {
        _xifexpression = "";
      } else {
        JvmType _type = ref.getType();
        _xifexpression = _type.getQualifiedName();
      }
      final String clazz = _xifexpression;
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("new PParameter(\"");
      String _name = variable.getName();
      _builder.append(_name, "");
      _builder.append("\", \"");
      _builder.append(clazz, "");
      _builder.append("\")");
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  public StringConcatenationClient inferAnnotations(final Pattern pattern) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          EList<Annotation> _annotations = pattern.getAnnotations();
          for(final Annotation annotation : _annotations) {
            _builder.append("                ");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(PAnnotation.class, "\t");
            _builder.append(" annotation = new ");
            _builder.append(PAnnotation.class, "\t");
            _builder.append("(\"");
            String _name = annotation.getName();
            _builder.append(_name, "\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            {
              Map<String, Object> _evaluateAnnotationParameters = CorePatternLanguageHelper.evaluateAnnotationParameters(annotation);
              Set<Map.Entry<String, Object>> _entrySet = _evaluateAnnotationParameters.entrySet();
              for(final Map.Entry<String, Object> attribute : _entrySet) {
                _builder.append("\t");
                _builder.append("annotation.addAttribute(\"");
                String _key = attribute.getKey();
                _builder.append(_key, "\t");
                _builder.append("\", ");
                Object _value = attribute.getValue();
                StringConcatenationClient _outputAnnotationParameter = PatternQuerySpecificationClassInferrer.this.outputAnnotationParameter(_value);
                _builder.append(_outputAnnotationParameter, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("addAnnotation(annotation);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    };
    return _client;
  }
  
  public StringConcatenationClient outputAnnotationParameter(final Object value) {
    StringConcatenationClient _switchResult = null;
    boolean _matched = false;
    if (!_matched) {
      if (value instanceof List) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(Arrays.class, "");
            _builder.append(".asList(new Object[] {");
            _builder.newLineIfNotEmpty();
            {
              boolean _hasElements = false;
              for(final Object item : ((List<?>)value)) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(", ", "                ");
                }
                _builder.append("                ");
                StringConcatenationClient _outputAnnotationParameter = PatternQuerySpecificationClassInferrer.this.outputAnnotationParameter(item);
                _builder.append(_outputAnnotationParameter, "                ");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("                ");
            _builder.append("})");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (value instanceof ParameterReference) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("new ");
            _builder.append(ParameterReference.class, "");
            _builder.append("(\"");
            String _name = ((ParameterReference)value).getName();
            _builder.append(_name, "");
            _builder.append("\")");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (value instanceof String) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("\"");
            _builder.append(((String)value), "");
            _builder.append("\"");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          String _string = value.toString();
          _builder.append(_string, "");
        }
      };
      _switchResult = _client;
    }
    return _switchResult;
  }
}
