package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.util.ElementOwnerQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.NamedElementNamespaceQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate InternalNamedElementNamespaceMatcher in a type-safe way.
 * 
 * @see InternalNamedElementNamespaceMatcher
 * @see InternalNamedElementNamespaceMatch
 * 
 */
@SuppressWarnings("all")
final class InternalNamedElementNamespaceQuerySpecification extends BaseGeneratedEMFQuerySpecification<IncQueryMatcher<IPatternMatch>> {
  private InternalNamedElementNamespaceQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static InternalNamedElementNamespaceQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected IncQueryMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    throw new UnsupportedOperationException();
  }
  
  @Override
  public IPatternMatch newEmptyMatch() {
    throw new UnsupportedOperationException();
  }
  
  @Override
  public IPatternMatch newMatch(final Object... parameters) {
    throw new UnsupportedOperationException();
  }
  
  private static class LazyHolder {
    private final static InternalNamedElementNamespaceQuerySpecification INSTANCE = make();
    
    public static InternalNamedElementNamespaceQuerySpecification make() {
      return new InternalNamedElementNamespaceQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static InternalNamedElementNamespaceQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.internalNamedElementNamespace";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("namedElement","namespace");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("namedElement", "org.eclipse.uml2.uml.NamedElement"),new PParameter("namespace", "org.eclipse.uml2.uml.Namespace"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_namedElement = body.getOrCreateVariableByName("namedElement");
      		PVariable var_namespace = body.getOrCreateVariableByName("namespace");
      		new TypeConstraint(body, new FlatTuple(var_namedElement), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")));
      		new TypeConstraint(body, new FlatTuple(var_namespace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Namespace")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_namedElement, "namedElement"),
      		   new ExportedParameter(body, var_namespace, "namespace")
      		));
      		//     find namedElementNamespace(namedElement, namespace)
      		new PositivePatternCall(body, new FlatTuple(var_namedElement, var_namespace), NamedElementNamespaceQuerySpecification.instance().getInternalQueryRepresentation());
      		bodies.add(body);
      	}
      	{
      		PBody body = new PBody(this);
      		PVariable var_namedElement = body.getOrCreateVariableByName("namedElement");
      		PVariable var_namespace = body.getOrCreateVariableByName("namespace");
      		PVariable var_parameter = body.getOrCreateVariableByName("parameter");
      		new TypeConstraint(body, new FlatTuple(var_namedElement), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")));
      		new TypeConstraint(body, new FlatTuple(var_namespace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Namespace")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_namedElement, "namedElement"),
      		   new ExportedParameter(body, var_namespace, "namespace")
      		));
      		//     find elementOwner(namedElement, parameter)
      		new PositivePatternCall(body, new FlatTuple(var_namedElement, var_parameter), ElementOwnerQuerySpecification.instance().getInternalQueryRepresentation());
      		//     TemplateableElement.ownedTemplateSignature.ownedParameter(namespace, parameter)
      		new TypeConstraint(body, new FlatTuple(var_namespace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "TemplateableElement")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_namespace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "TemplateableElement", "ownedTemplateSignature")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var__virtual_0_, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "TemplateSignature", "ownedParameter")));
      		new Equality(body, var__virtual_1_, var_parameter);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
