package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.uml.derivedfeatures.NamedElementQualifiedNameMatch;
import org.eclipse.incquery.uml.derivedfeatures.util.NamedElementQualifiedNameQuerySpecification;
import org.eclipse.uml2.uml.NamedElement;

/**
 * Generated pattern matcher API of the org.eclipse.incquery.uml.derivedfeatures.namedElementQualifiedName pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link NamedElementQualifiedNameMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * (if self.name {@literal <}{@literal >} null and self.allNamespaces()-{@literal >}select( ns | ns.name=null )-{@literal >}isEmpty()
 * then 
 *     self.allNamespaces()-{@literal >}iterate( ns : Namespace; agg: String = self.name | ns.name.concat(self.separator()).concat(agg))
 * else
 *    null
 * endif)
 * 
 * {@literal @}Surrogate(feature = "qualifiedName")
 * {@literal @}QueryExplorer(checked = false)
 * pattern namedElementQualifiedName(namedElement: NamedElement, qualifiedName) {
 *     neg find internalNamedElementNamespace(namedElement, _);
 *     NamedElement.name(namedElement, qualifiedName);
 *     // qualifiedName is null if any of the names are empty!
 *     qualifiedName != "";
 * } or {
 *     find internalNamedElementNamespace(namedElement, namespace);
 *     NamedElement.name(namedElement, name);
 *     // qualifiedName is null if any of the names are empty!
 *     name != "";
 *     find namedElementQualifiedName(namespace, namespaceQualifiedName);
 *     qualifiedName == eval(namespaceQualifiedName + "::" + name); // XXX is separator always this?
 * }
 * </pre></code>
 * 
 * @see NamedElementQualifiedNameMatch
 * @see NamedElementQualifiedNameProcessor
 * @see NamedElementQualifiedNameQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class NamedElementQualifiedNameMatcher extends BaseMatcher<NamedElementQualifiedNameMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static NamedElementQualifiedNameMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    NamedElementQualifiedNameMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new NamedElementQualifiedNameMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_NAMEDELEMENT = 0;
  
  private final static int POSITION_QUALIFIEDNAME = 1;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(NamedElementQualifiedNameMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public NamedElementQualifiedNameMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public NamedElementQualifiedNameMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pNamedElement the fixed value of pattern parameter namedElement, or null if not bound.
   * @param pQualifiedName the fixed value of pattern parameter qualifiedName, or null if not bound.
   * @return matches represented as a NamedElementQualifiedNameMatch object.
   * 
   */
  public Collection<NamedElementQualifiedNameMatch> getAllMatches(final NamedElement pNamedElement, final Object pQualifiedName) {
    return rawGetAllMatches(new Object[]{pNamedElement, pQualifiedName});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pNamedElement the fixed value of pattern parameter namedElement, or null if not bound.
   * @param pQualifiedName the fixed value of pattern parameter qualifiedName, or null if not bound.
   * @return a match represented as a NamedElementQualifiedNameMatch object, or null if no match is found.
   * 
   */
  public NamedElementQualifiedNameMatch getOneArbitraryMatch(final NamedElement pNamedElement, final Object pQualifiedName) {
    return rawGetOneArbitraryMatch(new Object[]{pNamedElement, pQualifiedName});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pNamedElement the fixed value of pattern parameter namedElement, or null if not bound.
   * @param pQualifiedName the fixed value of pattern parameter qualifiedName, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final NamedElement pNamedElement, final Object pQualifiedName) {
    return rawHasMatch(new Object[]{pNamedElement, pQualifiedName});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pNamedElement the fixed value of pattern parameter namedElement, or null if not bound.
   * @param pQualifiedName the fixed value of pattern parameter qualifiedName, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final NamedElement pNamedElement, final Object pQualifiedName) {
    return rawCountMatches(new Object[]{pNamedElement, pQualifiedName});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pNamedElement the fixed value of pattern parameter namedElement, or null if not bound.
   * @param pQualifiedName the fixed value of pattern parameter qualifiedName, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final NamedElement pNamedElement, final Object pQualifiedName, final IMatchProcessor<? super NamedElementQualifiedNameMatch> processor) {
    rawForEachMatch(new Object[]{pNamedElement, pQualifiedName}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pNamedElement the fixed value of pattern parameter namedElement, or null if not bound.
   * @param pQualifiedName the fixed value of pattern parameter qualifiedName, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final NamedElement pNamedElement, final Object pQualifiedName, final IMatchProcessor<? super NamedElementQualifiedNameMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pNamedElement, pQualifiedName}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pNamedElement the fixed value of pattern parameter namedElement, or null if not bound.
   * @param pQualifiedName the fixed value of pattern parameter qualifiedName, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public NamedElementQualifiedNameMatch newMatch(final NamedElement pNamedElement, final Object pQualifiedName) {
    return NamedElementQualifiedNameMatch.newMatch(pNamedElement, pQualifiedName);
  }
  
  /**
   * Retrieve the set of values that occur in matches for namedElement.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<NamedElement> rawAccumulateAllValuesOfnamedElement(final Object[] parameters) {
    Set<NamedElement> results = new HashSet<NamedElement>();
    rawAccumulateAllValues(POSITION_NAMEDELEMENT, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for namedElement.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<NamedElement> getAllValuesOfnamedElement() {
    return rawAccumulateAllValuesOfnamedElement(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for namedElement.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<NamedElement> getAllValuesOfnamedElement(final NamedElementQualifiedNameMatch partialMatch) {
    return rawAccumulateAllValuesOfnamedElement(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for namedElement.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<NamedElement> getAllValuesOfnamedElement(final Object pQualifiedName) {
    return rawAccumulateAllValuesOfnamedElement(new Object[]{
    null, 
    pQualifiedName
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for qualifiedName.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Object> rawAccumulateAllValuesOfqualifiedName(final Object[] parameters) {
    Set<Object> results = new HashSet<Object>();
    rawAccumulateAllValues(POSITION_QUALIFIEDNAME, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for qualifiedName.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Object> getAllValuesOfqualifiedName() {
    return rawAccumulateAllValuesOfqualifiedName(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for qualifiedName.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Object> getAllValuesOfqualifiedName(final NamedElementQualifiedNameMatch partialMatch) {
    return rawAccumulateAllValuesOfqualifiedName(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for qualifiedName.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Object> getAllValuesOfqualifiedName(final NamedElement pNamedElement) {
    return rawAccumulateAllValuesOfqualifiedName(new Object[]{
    pNamedElement, 
    null
    });
  }
  
  @Override
  protected NamedElementQualifiedNameMatch tupleToMatch(final Tuple t) {
    try {
    	return NamedElementQualifiedNameMatch.newMatch((org.eclipse.uml2.uml.NamedElement) t.get(POSITION_NAMEDELEMENT), (java.lang.Object) t.get(POSITION_QUALIFIEDNAME));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected NamedElementQualifiedNameMatch arrayToMatch(final Object[] match) {
    try {
    	return NamedElementQualifiedNameMatch.newMatch((org.eclipse.uml2.uml.NamedElement) match[POSITION_NAMEDELEMENT], (java.lang.Object) match[POSITION_QUALIFIEDNAME]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected NamedElementQualifiedNameMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return NamedElementQualifiedNameMatch.newMutableMatch((org.eclipse.uml2.uml.NamedElement) match[POSITION_NAMEDELEMENT], (java.lang.Object) match[POSITION_QUALIFIEDNAME]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<NamedElementQualifiedNameMatcher> querySpecification() throws IncQueryException {
    return NamedElementQualifiedNameQuerySpecification.instance();
  }
}
