package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.uml.derivedfeatures.NamedElementClientDependencyMatch;
import org.eclipse.incquery.uml.derivedfeatures.util.NamedElementClientDependencyQuerySpecification;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;

/**
 * Generated pattern matcher API of the org.eclipse.incquery.uml.derivedfeatures.namedElementClientDependency pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link NamedElementClientDependencyMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * (ownedAttribute-{@literal >}select(oclIsKindOf(Port))-{@literal >}collect(oclAsType(Port))-{@literal >}asOrderedSet())
 * 
 * // Can't compile OCL to IncQuery because of java.lang.UnsupportedOperationException: asOrderedSet
 * //{@literal @}Surrogate(feature = "ownedPort")
 * //pattern encapsulatedClassifierOwnedPort(source: EncapsulatedClassifier, target: Port) {}
 * 
 * 
 * (ownedEnd.lowerBound() = 1)
 * 
 * // Can't compile OCL to IncQuery because of org.eclipse.ocl.SemanticException: Cannot find operation (=(Integer)) for the type (Sequence(Integer))
 * //{@literal @}Surrogate(feature = "isRequired")
 * //pattern extensionIsRequired(source: Extension, target: Boolean) {}
 * 
 * 
 * (metaclassEnd().type.oclAsType(Class))
 * 
 * // Can't compile OCL to IncQuery because of java.lang.UnsupportedOperationException: metaclassEnd
 * //{@literal @}Surrogate(feature = "metaclass")
 * //pattern extensionMetaclass(source: Extension, target: Class) {}
 * 
 * 
 * (lowerBound())
 * 
 * // Can't compile OCL to IncQuery because of java.lang.UnsupportedOperationException: lowerBound
 * //{@literal @}Surrogate(feature = "lower")
 * //pattern multiplicityElementLower(source: MultiplicityElement, target: Integer) {}
 * 
 * 
 * (upperBound())
 * 
 * // Can't compile OCL to IncQuery because of java.lang.UnsupportedOperationException: upperBound
 * //{@literal @}Surrogate(feature = "upper")
 * //pattern multiplicityElementUpper(source: MultiplicityElement, target: UnlimitedNatural) {}
 * 
 * 
 * (Dependency.allInstances()-{@literal >}select(d | d.client-{@literal >}includes(self)))
 * 
 * {@literal @}Surrogate(feature = "clientDependency")
 * {@literal @}QueryExplorer(checked = false)
 * pattern namedElementClientDependency(
 *     self : NamedElement,
 *     d : Dependency
 * ) {
 *     Dependency.client(d, namedElement);
 *     namedElement == self;
 *     Dependency(dependency);
 *     d == dependency;
 * }
 * </pre></code>
 * 
 * @see NamedElementClientDependencyMatch
 * @see NamedElementClientDependencyProcessor
 * @see NamedElementClientDependencyQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class NamedElementClientDependencyMatcher extends BaseMatcher<NamedElementClientDependencyMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static NamedElementClientDependencyMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    NamedElementClientDependencyMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new NamedElementClientDependencyMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_SELF = 0;
  
  private final static int POSITION_D = 1;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(NamedElementClientDependencyMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public NamedElementClientDependencyMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public NamedElementClientDependencyMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pD the fixed value of pattern parameter d, or null if not bound.
   * @return matches represented as a NamedElementClientDependencyMatch object.
   * 
   */
  public Collection<NamedElementClientDependencyMatch> getAllMatches(final NamedElement pSelf, final Dependency pD) {
    return rawGetAllMatches(new Object[]{pSelf, pD});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pD the fixed value of pattern parameter d, or null if not bound.
   * @return a match represented as a NamedElementClientDependencyMatch object, or null if no match is found.
   * 
   */
  public NamedElementClientDependencyMatch getOneArbitraryMatch(final NamedElement pSelf, final Dependency pD) {
    return rawGetOneArbitraryMatch(new Object[]{pSelf, pD});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pD the fixed value of pattern parameter d, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final NamedElement pSelf, final Dependency pD) {
    return rawHasMatch(new Object[]{pSelf, pD});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pD the fixed value of pattern parameter d, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final NamedElement pSelf, final Dependency pD) {
    return rawCountMatches(new Object[]{pSelf, pD});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pD the fixed value of pattern parameter d, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final NamedElement pSelf, final Dependency pD, final IMatchProcessor<? super NamedElementClientDependencyMatch> processor) {
    rawForEachMatch(new Object[]{pSelf, pD}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pD the fixed value of pattern parameter d, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final NamedElement pSelf, final Dependency pD, final IMatchProcessor<? super NamedElementClientDependencyMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pSelf, pD}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pD the fixed value of pattern parameter d, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public NamedElementClientDependencyMatch newMatch(final NamedElement pSelf, final Dependency pD) {
    return NamedElementClientDependencyMatch.newMatch(pSelf, pD);
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<NamedElement> rawAccumulateAllValuesOfself(final Object[] parameters) {
    Set<NamedElement> results = new HashSet<NamedElement>();
    rawAccumulateAllValues(POSITION_SELF, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<NamedElement> getAllValuesOfself() {
    return rawAccumulateAllValuesOfself(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<NamedElement> getAllValuesOfself(final NamedElementClientDependencyMatch partialMatch) {
    return rawAccumulateAllValuesOfself(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<NamedElement> getAllValuesOfself(final Dependency pD) {
    return rawAccumulateAllValuesOfself(new Object[]{
    null, 
    pD
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for d.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Dependency> rawAccumulateAllValuesOfd(final Object[] parameters) {
    Set<Dependency> results = new HashSet<Dependency>();
    rawAccumulateAllValues(POSITION_D, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for d.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Dependency> getAllValuesOfd() {
    return rawAccumulateAllValuesOfd(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for d.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Dependency> getAllValuesOfd(final NamedElementClientDependencyMatch partialMatch) {
    return rawAccumulateAllValuesOfd(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for d.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Dependency> getAllValuesOfd(final NamedElement pSelf) {
    return rawAccumulateAllValuesOfd(new Object[]{
    pSelf, 
    null
    });
  }
  
  @Override
  protected NamedElementClientDependencyMatch tupleToMatch(final Tuple t) {
    try {
    	return NamedElementClientDependencyMatch.newMatch((org.eclipse.uml2.uml.NamedElement) t.get(POSITION_SELF), (org.eclipse.uml2.uml.Dependency) t.get(POSITION_D));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected NamedElementClientDependencyMatch arrayToMatch(final Object[] match) {
    try {
    	return NamedElementClientDependencyMatch.newMatch((org.eclipse.uml2.uml.NamedElement) match[POSITION_SELF], (org.eclipse.uml2.uml.Dependency) match[POSITION_D]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected NamedElementClientDependencyMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return NamedElementClientDependencyMatch.newMutableMatch((org.eclipse.uml2.uml.NamedElement) match[POSITION_SELF], (org.eclipse.uml2.uml.Dependency) match[POSITION_D]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<NamedElementClientDependencyMatcher> querySpecification() throws IncQueryException {
    return NamedElementClientDependencyQuerySpecification.instance();
  }
}
