package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.ConnectorKindMatch;
import org.eclipse.incquery.uml.derivedfeatures.ConnectorKindMatcher;
import org.eclipse.incquery.uml.derivedfeatures.util.ConnectorKindDelegationQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate ConnectorKindMatcher in a type-safe way.
 * 
 * @see ConnectorKindMatcher
 * @see ConnectorKindMatch
 * 
 */
@SuppressWarnings("all")
public final class ConnectorKindQuerySpecification extends BaseGeneratedEMFQuerySpecification<ConnectorKindMatcher> {
  private ConnectorKindQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static ConnectorKindQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected ConnectorKindMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return ConnectorKindMatcher.on(engine);
  }
  
  @Override
  public ConnectorKindMatch newEmptyMatch() {
    return ConnectorKindMatch.newEmptyMatch();
  }
  
  @Override
  public ConnectorKindMatch newMatch(final Object... parameters) {
    return ConnectorKindMatch.newMatch((org.eclipse.uml2.uml.Connector) parameters[0], (org.eclipse.uml2.uml.ConnectorKind) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static ConnectorKindQuerySpecification INSTANCE = make();
    
    public static ConnectorKindQuerySpecification make() {
      return new ConnectorKindQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static ConnectorKindQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.connectorKind";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","kind");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("self", "org.eclipse.uml2.uml.Connector"),new PParameter("kind", "org.eclipse.uml2.uml.ConnectorKind"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_self = body.getOrCreateVariableByName("self");
      	PVariable var_kind = body.getOrCreateVariableByName("kind");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_self, "self"),
      				
      		new ExportedParameter(body, var_kind, "kind")
      	));
      	new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Connector")));
      	new TypeConstraint(body, new FlatTuple(var_kind), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "ConnectorKind")));
      	new PositivePatternCall(body, new FlatTuple(var_self), ConnectorKindDelegationQuerySpecification.instance().getInternalQueryRepresentation());
      	new ConstantValue(body, var__virtual_0_, org.eclipse.uml2.uml.ConnectorKind.get("delegation"));
      	new Equality(body, var_kind, var__virtual_0_);
      	bodies.add(body);
      }
      {
      	PBody body = new PBody(this);
      	PVariable var_self = body.getOrCreateVariableByName("self");
      	PVariable var_kind = body.getOrCreateVariableByName("kind");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_self, "self"),
      				
      		new ExportedParameter(body, var_kind, "kind")
      	));
      	new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Connector")));
      	new TypeConstraint(body, new FlatTuple(var_kind), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "ConnectorKind")));
      	new NegativePatternCall(body, new FlatTuple(var_self), ConnectorKindDelegationQuerySpecification.instance().getInternalQueryRepresentation());
      	new ConstantValue(body, var__virtual_0_, org.eclipse.uml2.uml.ConnectorKind.get("assembly"));
      	new Equality(body, var_kind, var__virtual_0_);
      	bodies.add(body);
      }
      	{
      	PAnnotation annotation = new PAnnotation("Surrogate");
      	annotation.addAttribute("feature", "kind");
      	addAnnotation(annotation);
      }
      {
      	PAnnotation annotation = new PAnnotation("QueryExplorer");
      	annotation.addAttribute("checked", false);
      	addAnnotation(annotation);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
