/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.single;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.matchers.tuple.TupleMask;
import org.eclipse.incquery.runtime.rete.index.MemoryIdentityIndexer;
import org.eclipse.incquery.runtime.rete.index.MemoryNullIndexer;
import org.eclipse.incquery.runtime.rete.index.ProjectionIndexer;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.network.StandardNode;
import org.eclipse.incquery.runtime.rete.network.Supplier;
import org.eclipse.incquery.runtime.rete.network.Tunnel;
import org.eclipse.incquery.runtime.rete.traceability.TraceInfo;
import org.eclipse.incquery.runtime.rete.tuple.TupleMemory;

public class UniquenessEnforcerNode
extends StandardNode
implements Tunnel {
    protected Collection<Supplier> parents = new ArrayList<Supplier>();
    protected TupleMemory memory = new TupleMemory();
    protected MemoryNullIndexer memoryNullIndexer;
    protected MemoryIdentityIndexer memoryIdentityIndexer;
    protected final int tupleWidth;
    private final TupleMask nullMask;
    private final TupleMask identityMask;

    public TupleMemory getMemory() {
        return this.memory;
    }

    public UniquenessEnforcerNode(ReteContainer reteContainer, int tupleWidth) {
        super(reteContainer);
        this.tupleWidth = tupleWidth;
        reteContainer.registerClearable(this.memory);
        this.nullMask = TupleMask.linear((int)0, (int)tupleWidth);
        this.identityMask = TupleMask.identity((int)tupleWidth);
    }

    @Override
    public void update(Direction direction, Tuple updateElement) {
        boolean change;
        if (direction == Direction.INSERT) {
            change = this.memory.add(updateElement);
        } else {
            try {
                change = this.memory.remove(updateElement);
            }
            catch (NullPointerException ex) {
                change = false;
                this.reteContainer.getNetwork().getContext().logError("[INTERNAL ERROR] Duplicate deletion of " + updateElement + " was detected in UniquenessEnforcer " + this + " for pattern(s) " + this.getTraceInfoPatternsEnumerated(), (Throwable)ex);
            }
        }
        if (change) {
            this.propagateUpdate(direction, updateElement);
            if (this.memoryIdentityIndexer != null) {
                this.memoryIdentityIndexer.propagate(direction, updateElement);
            }
            if (this.memoryNullIndexer != null) {
                this.memoryNullIndexer.propagate(direction, updateElement);
            }
        }
    }

    @Override
    public ProjectionIndexer constructIndex(TupleMask mask, TraceInfo ... traces) {
        if (this.nullMask.equals((Object)mask)) {
            MemoryNullIndexer indexer = this.getNullIndexer();
            TraceInfo[] traceInfoArray = traces;
            int n = traces.length;
            int n2 = 0;
            while (n2 < n) {
                TraceInfo traceInfo = traceInfoArray[n2];
                indexer.assignTraceInfo(traceInfo);
                ++n2;
            }
            return indexer;
        }
        if (this.identityMask.equals((Object)mask)) {
            MemoryIdentityIndexer indexer = this.getIdentityIndexer();
            TraceInfo[] traceInfoArray = traces;
            int n = traces.length;
            int n3 = 0;
            while (n3 < n) {
                TraceInfo traceInfo = traceInfoArray[n3];
                indexer.assignTraceInfo(traceInfo);
                ++n3;
            }
            return indexer;
        }
        return super.constructIndex(mask, traces);
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        collector.addAll(this.memory);
    }

    public MemoryNullIndexer getNullIndexer() {
        if (this.memoryNullIndexer == null) {
            this.memoryNullIndexer = new MemoryNullIndexer(this.reteContainer, this.tupleWidth, this.memory, this, this);
        }
        return this.memoryNullIndexer;
    }

    public MemoryIdentityIndexer getIdentityIndexer() {
        if (this.memoryIdentityIndexer == null) {
            this.memoryIdentityIndexer = new MemoryIdentityIndexer(this.reteContainer, this.tupleWidth, this.memory, this, this);
        }
        return this.memoryIdentityIndexer;
    }

    @Override
    public void appendParent(Supplier supplier) {
        this.parents.add(supplier);
    }

    @Override
    public void removeParent(Supplier supplier) {
        this.parents.remove(supplier);
    }

    @Override
    public Collection<Supplier> getParents() {
        return this.parents;
    }

    @Override
    public void assignTraceInfo(TraceInfo traceInfo) {
        super.assignTraceInfo(traceInfo);
        if (traceInfo.propagateFromStandardNodeToSupplierParent()) {
            for (Supplier parent : this.parents) {
                parent.acceptPropagatedTraceInfo(traceInfo);
            }
        }
    }
}

