/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.api.event.adapter;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.RuleInstance;
import org.eclipse.incquery.runtime.evm.api.event.Event;

public abstract class EventProcessorAdapter<EventAtom> {
    private final RuleInstance<EventAtom> instance;

    protected EventProcessorAdapter(RuleInstance<EventAtom> instance) {
        this.instance = instance;
    }

    public void processEvent(Event<EventAtom> event) {
        Preconditions.checkNotNull(event, (Object)"Cannot process null event!");
        Map column = this.getInstance().getActivations().column(event.getEventAtom());
        if (column.size() > 0) {
            Preconditions.checkArgument((column.size() == 1 ? 1 : 0) != 0, (Object)String.format("%s activations in the same rule for the same match", column.size() == 0 ? "No" : "Multiple"));
            Activation act = (Activation)column.values().iterator().next();
            this.activationExists(event, act);
        } else {
            this.activationMissing(event);
        }
    }

    protected abstract void activationExists(Event<EventAtom> var1, Activation<EventAtom> var2);

    protected abstract void activationMissing(Event<EventAtom> var1);

    protected RuleInstance<EventAtom> getInstance() {
        return this.instance;
    }
}

