/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.resource.v1alpha1.AllocationResult;
import io.fabric8.kubernetes.api.model.resource.v1alpha1.AllocationResultBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha1.AllocationResultFluentImpl;
import io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClaimConsumerReference;
import io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClaimConsumerReferenceBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClaimConsumerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClaimStatus;
import io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClaimStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ResourceClaimStatusFluentImpl<A extends ResourceClaimStatusFluent<A>>
extends BaseFluent<A>
implements ResourceClaimStatusFluent<A> {
    private AllocationResultBuilder allocation;
    private Boolean deallocationRequested;
    private String driverName;
    private ArrayList<ResourceClaimConsumerReferenceBuilder> reservedFor = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ResourceClaimStatusFluentImpl() {
    }

    public ResourceClaimStatusFluentImpl(ResourceClaimStatus instance) {
        if (instance != null) {
            this.withAllocation(instance.getAllocation());
            this.withDeallocationRequested(instance.getDeallocationRequested());
            this.withDriverName(instance.getDriverName());
            this.withReservedFor(instance.getReservedFor());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    @Deprecated
    public AllocationResult getAllocation() {
        return this.allocation != null ? this.allocation.build() : null;
    }

    @Override
    public AllocationResult buildAllocation() {
        return this.allocation != null ? this.allocation.build() : null;
    }

    @Override
    public A withAllocation(AllocationResult allocation) {
        this._visitables.get("allocation").remove(this.allocation);
        if (allocation != null) {
            this.allocation = new AllocationResultBuilder(allocation);
            this._visitables.get("allocation").add(this.allocation);
        } else {
            this.allocation = null;
            this._visitables.get("allocation").remove(this.allocation);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllocation() {
        return this.allocation != null;
    }

    @Override
    public ResourceClaimStatusFluent.AllocationNested<A> withNewAllocation() {
        return new AllocationNestedImpl();
    }

    @Override
    public ResourceClaimStatusFluent.AllocationNested<A> withNewAllocationLike(AllocationResult item) {
        return new AllocationNestedImpl(item);
    }

    @Override
    public ResourceClaimStatusFluent.AllocationNested<A> editAllocation() {
        return this.withNewAllocationLike(this.getAllocation());
    }

    @Override
    public ResourceClaimStatusFluent.AllocationNested<A> editOrNewAllocation() {
        return this.withNewAllocationLike(this.getAllocation() != null ? this.getAllocation() : new AllocationResultBuilder().build());
    }

    @Override
    public ResourceClaimStatusFluent.AllocationNested<A> editOrNewAllocationLike(AllocationResult item) {
        return this.withNewAllocationLike(this.getAllocation() != null ? this.getAllocation() : item);
    }

    @Override
    public Boolean getDeallocationRequested() {
        return this.deallocationRequested;
    }

    @Override
    public A withDeallocationRequested(Boolean deallocationRequested) {
        this.deallocationRequested = deallocationRequested;
        return (A)this;
    }

    @Override
    public Boolean hasDeallocationRequested() {
        return this.deallocationRequested != null;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public A withDriverName(String driverName) {
        this.driverName = driverName;
        return (A)this;
    }

    @Override
    public Boolean hasDriverName() {
        return this.driverName != null;
    }

    @Override
    public A addToReservedFor(int index, ResourceClaimConsumerReference item) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);
        if (index < 0 || index >= this.reservedFor.size()) {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        } else {
            this._visitables.get("reservedFor").add(index, builder);
            this.reservedFor.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToReservedFor(int index, ResourceClaimConsumerReference item) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);
        if (index < 0 || index >= this.reservedFor.size()) {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        } else {
            this._visitables.get("reservedFor").set(index, builder);
            this.reservedFor.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToReservedFor(ResourceClaimConsumerReference ... items) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        for (ResourceClaimConsumerReference item : items) {
            ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToReservedFor(Collection<ResourceClaimConsumerReference> items) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        for (ResourceClaimConsumerReference item : items) {
            ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromReservedFor(ResourceClaimConsumerReference ... items) {
        for (ResourceClaimConsumerReference item : items) {
            ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").remove(builder);
            if (this.reservedFor == null) continue;
            this.reservedFor.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromReservedFor(Collection<ResourceClaimConsumerReference> items) {
        for (ResourceClaimConsumerReference item : items) {
            ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").remove(builder);
            if (this.reservedFor == null) continue;
            this.reservedFor.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
        if (this.reservedFor == null) {
            return (A)this;
        }
        Iterator<ResourceClaimConsumerReferenceBuilder> each = this.reservedFor.iterator();
        Object visitables = this._visitables.get("reservedFor");
        while (each.hasNext()) {
            ResourceClaimConsumerReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ResourceClaimConsumerReference> getReservedFor() {
        return this.reservedFor != null ? ResourceClaimStatusFluentImpl.build(this.reservedFor) : null;
    }

    @Override
    public List<ResourceClaimConsumerReference> buildReservedFor() {
        return this.reservedFor != null ? ResourceClaimStatusFluentImpl.build(this.reservedFor) : null;
    }

    @Override
    public ResourceClaimConsumerReference buildReservedFor(int index) {
        return this.reservedFor.get(index).build();
    }

    @Override
    public ResourceClaimConsumerReference buildFirstReservedFor() {
        return this.reservedFor.get(0).build();
    }

    @Override
    public ResourceClaimConsumerReference buildLastReservedFor() {
        return this.reservedFor.get(this.reservedFor.size() - 1).build();
    }

    @Override
    public ResourceClaimConsumerReference buildMatchingReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
        for (ResourceClaimConsumerReferenceBuilder item : this.reservedFor) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
        for (ResourceClaimConsumerReferenceBuilder item : this.reservedFor) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withReservedFor(List<ResourceClaimConsumerReference> reservedFor) {
        if (this.reservedFor != null) {
            this._visitables.get("reservedFor").clear();
        }
        if (reservedFor != null) {
            this.reservedFor = new ArrayList();
            for (ResourceClaimConsumerReference item : reservedFor) {
                this.addToReservedFor(item);
            }
        } else {
            this.reservedFor = null;
        }
        return (A)this;
    }

    @Override
    public A withReservedFor(ResourceClaimConsumerReference ... reservedFor) {
        if (this.reservedFor != null) {
            this.reservedFor.clear();
            this._visitables.remove("reservedFor");
        }
        if (reservedFor != null) {
            for (ResourceClaimConsumerReference item : reservedFor) {
                this.addToReservedFor(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasReservedFor() {
        return this.reservedFor != null && !this.reservedFor.isEmpty();
    }

    @Override
    public A addNewReservedFor(String apiGroup, String name, String resource, String uid) {
        return this.addToReservedFor(new ResourceClaimConsumerReference(apiGroup, name, resource, uid));
    }

    @Override
    public ResourceClaimStatusFluent.ReservedForNested<A> addNewReservedFor() {
        return new ReservedForNestedImpl();
    }

    @Override
    public ResourceClaimStatusFluent.ReservedForNested<A> addNewReservedForLike(ResourceClaimConsumerReference item) {
        return new ReservedForNestedImpl(-1, item);
    }

    @Override
    public ResourceClaimStatusFluent.ReservedForNested<A> setNewReservedForLike(int index, ResourceClaimConsumerReference item) {
        return new ReservedForNestedImpl(index, item);
    }

    @Override
    public ResourceClaimStatusFluent.ReservedForNested<A> editReservedFor(int index) {
        if (this.reservedFor.size() <= index) {
            throw new RuntimeException("Can't edit reservedFor. Index exceeds size.");
        }
        return this.setNewReservedForLike(index, this.buildReservedFor(index));
    }

    @Override
    public ResourceClaimStatusFluent.ReservedForNested<A> editFirstReservedFor() {
        if (this.reservedFor.size() == 0) {
            throw new RuntimeException("Can't edit first reservedFor. The list is empty.");
        }
        return this.setNewReservedForLike(0, this.buildReservedFor(0));
    }

    @Override
    public ResourceClaimStatusFluent.ReservedForNested<A> editLastReservedFor() {
        int index = this.reservedFor.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last reservedFor. The list is empty.");
        }
        return this.setNewReservedForLike(index, this.buildReservedFor(index));
    }

    @Override
    public ResourceClaimStatusFluent.ReservedForNested<A> editMatchingReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.reservedFor.size(); ++i) {
            if (!predicate.test(this.reservedFor.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching reservedFor. No match found.");
        }
        return this.setNewReservedForLike(index, this.buildReservedFor(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceClaimStatusFluentImpl that = (ResourceClaimStatusFluentImpl)o;
        if (!Objects.equals(this.allocation, that.allocation)) {
            return false;
        }
        if (!Objects.equals(this.deallocationRequested, that.deallocationRequested)) {
            return false;
        }
        if (!Objects.equals(this.driverName, that.driverName)) {
            return false;
        }
        if (!Objects.equals(this.reservedFor, that.reservedFor)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allocation, this.deallocationRequested, this.driverName, this.reservedFor, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocation != null) {
            sb.append("allocation:");
            sb.append(this.allocation + ",");
        }
        if (this.deallocationRequested != null) {
            sb.append("deallocationRequested:");
            sb.append(this.deallocationRequested + ",");
        }
        if (this.driverName != null) {
            sb.append("driverName:");
            sb.append(this.driverName + ",");
        }
        if (this.reservedFor != null) {
            sb.append("reservedFor:");
            sb.append(this.reservedFor + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withDeallocationRequested() {
        return this.withDeallocationRequested(true);
    }

    class ReservedForNestedImpl<N>
    extends ResourceClaimConsumerReferenceFluentImpl<ResourceClaimStatusFluent.ReservedForNested<N>>
    implements ResourceClaimStatusFluent.ReservedForNested<N>,
    Nested<N> {
        ResourceClaimConsumerReferenceBuilder builder;
        int index;

        ReservedForNestedImpl(int index, ResourceClaimConsumerReference item) {
            this.index = index;
            this.builder = new ResourceClaimConsumerReferenceBuilder(this, item);
        }

        ReservedForNestedImpl() {
            this.index = -1;
            this.builder = new ResourceClaimConsumerReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceClaimStatusFluentImpl.this.setToReservedFor(this.index, this.builder.build());
        }

        @Override
        public N endReservedFor() {
            return this.and();
        }
    }

    class AllocationNestedImpl<N>
    extends AllocationResultFluentImpl<ResourceClaimStatusFluent.AllocationNested<N>>
    implements ResourceClaimStatusFluent.AllocationNested<N>,
    Nested<N> {
        AllocationResultBuilder builder;

        AllocationNestedImpl(AllocationResult item) {
            this.builder = new AllocationResultBuilder(this, item);
        }

        AllocationNestedImpl() {
            this.builder = new AllocationResultBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceClaimStatusFluentImpl.this.withAllocation(this.builder.build());
        }

        @Override
        public N endAllocation() {
            return this.and();
        }
    }
}

