/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;

@VertxGen
public interface HSTSHandler
extends Handler<RoutingContext> {
    public static final long DEFAULT_MAX_AGE = 15768000L;

    public static HSTSHandler create(long maxAge, boolean includeSubDomains) {
        String header = includeSubDomains ? "max-age=" + maxAge + "; includeSubdomains" : "max-age=" + maxAge;
        return ctx -> {
            boolean isSecure;
            HttpServerRequest request = ctx.request();
            boolean bl = isSecure = request.isSSL() || "on".equalsIgnoreCase(request.getHeader("Front-End-Https"));
            if (isSecure) {
                request.response().putHeader("Strict-Transport-Security", header);
            }
            ctx.next();
        };
    }

    public static HSTSHandler create(boolean includeSubDomains) {
        return HSTSHandler.create(15768000L, includeSubDomains);
    }

    public static HSTSHandler create() {
        return HSTSHandler.create(false);
    }
}

