/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.servlet.utils;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.graph.GraphWrapper;
import org.eclipse.hawk.graph.ModelElementNode;
import org.eclipse.hawk.graph.TypeNode;
import org.eclipse.hawk.service.api.AttributeSlot;
import org.eclipse.hawk.service.api.ContainerSlot;
import org.eclipse.hawk.service.api.EffectiveMetamodelRuleset;
import org.eclipse.hawk.service.api.MixedReference;
import org.eclipse.hawk.service.api.ModelElement;
import org.eclipse.hawk.service.api.ReferenceSlot;
import org.eclipse.hawk.service.api.SlotValue;
import org.eclipse.hawk.service.servlet.utils.IdentityLinkedHashSet;

public class HawkModelElementEncoder {
    private final GraphWrapper graph;
    private final Map<String, ModelElement> nodeIdToElement = new HashMap<String, ModelElement>();
    private final Set<ModelElement> rootElements = new IdentityLinkedHashSet<ModelElement>();
    private String lastMetamodelURI;
    private String lastTypename;
    private String lastRepository;
    private String lastFile;
    private boolean discardContainerRefs = false;
    private boolean includeAttributes = true;
    private boolean includeReferences = true;
    private boolean includeDerived = true;
    private boolean sendElementNodeIDs = false;
    private boolean sortByNodeIDs = false;
    private boolean useContainment = true;
    private EffectiveMetamodelRuleset effectiveMetamodel = new EffectiveMetamodelRuleset();

    public HawkModelElementEncoder(GraphWrapper gw) {
        this.graph = gw;
    }

    public boolean isIncludeNodeIDs() {
        return this.sendElementNodeIDs;
    }

    public void setIncludeNodeIDs(boolean newValue) {
        this.sendElementNodeIDs = newValue;
    }

    public boolean isUseContainment() {
        return this.useContainment;
    }

    public void setUseContainment(boolean useContainment) {
        this.useContainment = useContainment;
    }

    public boolean isSortByNodeIDs() {
        return this.sortByNodeIDs;
    }

    public void setSortByNodeIDs(boolean sortByNodeIDs) {
        this.sortByNodeIDs = sortByNodeIDs;
    }

    public boolean isIncludeAttributes() {
        return this.includeAttributes;
    }

    public void setIncludeAttributes(boolean includeAttributes) {
        this.includeAttributes = includeAttributes;
    }

    public boolean isIncludeReferences() {
        return this.includeReferences;
    }

    public void setIncludeReferences(boolean includeReferences) {
        this.includeReferences = includeReferences;
    }

    public boolean isIncludeDerived() {
        return this.includeDerived;
    }

    public void setIncludeDerived(boolean includeDerived) {
        this.includeDerived = includeDerived;
    }

    public boolean isDiscardContainerRefs() {
        return this.discardContainerRefs;
    }

    public void setDiscardContainerRefs(boolean discardContainerRefs) {
        this.discardContainerRefs = discardContainerRefs;
    }

    public List<ModelElement> getElements() {
        ArrayList<ModelElement> lRoots = new ArrayList<ModelElement>(this.rootElements);
        if (this.isSortByNodeIDs()) {
            this.sortTreeByNodeId(lRoots);
        }
        HashMap<String, Integer> id2pos = new HashMap<String, Integer>();
        this.computePreorderPositionMap(lRoots, id2pos, 0);
        this.lastTypename = null;
        this.lastMetamodelURI = null;
        this.optimizeTree(lRoots, id2pos);
        return lRoots;
    }

    private void sortTreeByNodeId(List<ModelElement> elements) {
        Collections.sort(elements, new Comparator<ModelElement>(){

            @Override
            public int compare(ModelElement l, ModelElement r) {
                return l.getId().compareTo(r.getId());
            }
        });
        for (ModelElement me : elements) {
            if (!me.isSetContainers()) continue;
            for (ContainerSlot s : me.getContainers()) {
                this.sortTreeByNodeId(s.elements);
            }
        }
    }

    private int computePreorderPositionMap(Collection<ModelElement> elems, Map<String, Integer> id2pos, int i) {
        for (ModelElement elem : elems) {
            if (elem.isSetId()) {
                id2pos.put(elem.id, i);
            }
            ++i;
            if (!elem.isSetContainers()) continue;
            for (ContainerSlot s : elem.containers) {
                i = this.computePreorderPositionMap(s.elements, id2pos, i);
            }
        }
        return i;
    }

    private void optimizeTree(Collection<ModelElement> elems, Map<String, Integer> id2pos) {
        for (ModelElement me : elems) {
            if (!this.isIncludeNodeIDs()) {
                me.unsetId();
            }
            if (me.isSetReferences()) {
                for (ReferenceSlot r : me.getReferences()) {
                    this.optimizeReferenceSlot(id2pos, r);
                }
            }
            this.optimizeRepeatedAttributes(me);
            if (!me.isSetContainers()) continue;
            for (ContainerSlot s : me.getContainers()) {
                this.optimizeTree(s.elements, id2pos);
            }
        }
    }

    private void optimizeRepeatedAttributes(ModelElement me) {
        String currTypename = me.getTypeName();
        String currMetamodelURI = me.getMetamodelUri();
        String currRepositoryURL = me.getRepositoryURL();
        String currFilePath = me.getFile();
        if (this.lastTypename != null && this.lastTypename.equals(currTypename)) {
            me.unsetTypeName();
        }
        if (this.lastMetamodelURI != null && this.lastMetamodelURI.equals(currMetamodelURI)) {
            me.unsetMetamodelUri();
        }
        if (this.lastRepository != null && this.lastRepository.equals(currRepositoryURL)) {
            me.unsetRepositoryURL();
        }
        if (this.lastFile != null && this.lastFile.equals(currFilePath)) {
            me.unsetFile();
        }
        this.lastTypename = currTypename;
        this.lastMetamodelURI = currMetamodelURI;
        this.lastRepository = currRepositoryURL;
        this.lastFile = currFilePath;
    }

    private void optimizeReferenceSlot(Map<String, Integer> id2pos, ReferenceSlot r) {
        Map<Integer, Integer> local2global = this.computeLocalToGlobalPositionMap(id2pos, r);
        if (local2global.isEmpty()) {
            if (r.ids.size() == 1) {
                r.setId((String)r.ids.get(0));
                r.unsetIds();
            }
        } else if (local2global.size() == r.ids.size()) {
            if (local2global.size() == 1) {
                r.setPosition(local2global.get(0).intValue());
                r.unsetIds();
            } else {
                r.setPositions(new ArrayList<Integer>(local2global.values()));
                r.unsetIds();
            }
        } else {
            ArrayList<MixedReference> mixed = new ArrayList<MixedReference>();
            int i = 0;
            for (String id : r.ids) {
                Integer globalPosition = local2global.get(i);
                if (globalPosition == null) {
                    mixed.add(new MixedReference(MixedReference._Fields.ID, (Object)id));
                } else {
                    mixed.add(new MixedReference(MixedReference._Fields.POSITION, (Object)globalPosition));
                }
                ++i;
            }
            r.setMixed(mixed);
            r.unsetIds();
        }
    }

    private Map<Integer, Integer> computeLocalToGlobalPositionMap(Map<String, Integer> id2pos, ReferenceSlot r) {
        int i = 0;
        LinkedHashMap<Integer, Integer> local2global = new LinkedHashMap<Integer, Integer>();
        for (String id : r.ids) {
            Integer pos = id2pos.get(id);
            if (pos != null) {
                local2global.put(i, pos);
            }
            ++i;
        }
        return local2global;
    }

    public ModelElement encode(String id) throws Exception {
        ModelElementNode me = this.graph.getModelElementNodeById((Object)id);
        return this.encode(me);
    }

    public ModelElement encode(IGraphNode node) throws Exception {
        return this.encode(new ModelElementNode(node));
    }

    public ModelElement encode(ModelElementNode meNode) throws Exception {
        assert (meNode.getNode().getGraph() == this.graph.getGraph()) : "The node should belong to the same graph as this encoder";
        if (this.isEncodable(meNode)) {
            return this.encodeInternal(meNode);
        }
        return null;
    }

    public boolean isEncoded(String id) {
        return this.nodeIdToElement.containsKey(id);
    }

    public boolean isEncoded(ModelElementNode meNode) {
        return this.isEncoded(meNode.getNodeId());
    }

    private boolean isEncodable(ModelElementNode meNode) {
        return this.effectiveMetamodel.isEverythingIncluded() || this.effectiveMetamodel.isIncluded(meNode.getTypeNode().getMetamodelURI(), meNode.getTypeNode().getTypeName());
    }

    public EffectiveMetamodelRuleset getEffectiveMetamodel() {
        return this.effectiveMetamodel;
    }

    public void setEffectiveMetamodel(EffectiveMetamodelRuleset effectiveMetamodel) {
        this.effectiveMetamodel = effectiveMetamodel;
    }

    private ModelElement encodeInternal(ModelElementNode meNode) throws Exception {
        HashMap derived;
        ModelElement existing = this.nodeIdToElement.get(meNode.getNodeId());
        if (existing != null) {
            return existing;
        }
        TypeNode typeNode = meNode.getTypeNode();
        String typeName = typeNode.getTypeName();
        String metamodelURI = typeNode.getMetamodelURI();
        ModelElement me = new ModelElement();
        me.setId(meNode.getNodeId());
        me.setTypeName(typeName);
        me.setMetamodelUri(metamodelURI);
        me.setFile(meNode.getFileNode().getFilePath());
        me.setRepositoryURL(meNode.getFileNode().getRepositoryURL());
        this.nodeIdToElement.put(meNode.getNodeId(), me);
        this.rootElements.add(me);
        HashMap attrs = this.isIncludeAttributes() ? new HashMap() : null;
        HashMap refs = this.isIncludeReferences() ? new HashMap() : null;
        Map mixed = null;
        HashMap hashMap = derived = this.isIncludeDerived() ? new HashMap() : null;
        if (this.isIncludeAttributes() || this.isIncludeReferences() || this.isIncludeDerived()) {
            meNode.getSlotValues(attrs, refs, mixed, derived);
        }
        if (this.isIncludeAttributes()) {
            for (Map.Entry entry : attrs.entrySet()) {
                if (entry.getValue() == null || !this.effectiveMetamodel.isIncluded(metamodelURI, typeName, (String)entry.getKey())) continue;
                me.addToAttributes(HawkModelElementEncoder.encodeAttributeSlot((String)entry.getKey(), entry.getValue()));
            }
        }
        if (this.isIncludeReferences()) {
            for (Map.Entry<String, Object> entry : refs.entrySet()) {
                if (entry.getValue() == null || !this.effectiveMetamodel.isIncluded(metamodelURI, typeName, (String)entry.getKey())) continue;
                this.encodeReference(meNode, me, entry);
            }
        }
        if (this.isIncludeDerived()) {
            for (Map.Entry<String, Object> entry : derived.entrySet()) {
                Object value = entry.getValue();
                if (value == null || !this.effectiveMetamodel.isIncluded(metamodelURI, typeName, (String)entry.getKey())) continue;
                boolean isDerivedReference = false;
                if (value instanceof IGraphNode) {
                    isDerivedReference = true;
                } else if (value instanceof Iterable) {
                    Iterator itValues = ((Iterable)value).iterator();
                    if (!itValues.hasNext()) continue;
                    if (itValues.next() instanceof IGraphNode) {
                        isDerivedReference = true;
                    }
                }
                if (isDerivedReference) {
                    if (!this.isIncludeReferences()) continue;
                    this.encodeReference(meNode, me, entry);
                    continue;
                }
                if (!this.isIncludeAttributes()) continue;
                me.addToAttributes(HawkModelElementEncoder.encodeAttributeSlot((String)entry.getKey(), entry.getValue()));
            }
        }
        return me;
    }

    protected void encodeReference(ModelElementNode meNode, ModelElement me, Map.Entry<String, Object> ref) throws Exception {
        if (this.useContainment && meNode.isContainment(ref.getKey())) {
            ContainerSlot slot = this.encodeContainerSlot(meNode, ref);
            if (!slot.isSetElements() || slot.elements.isEmpty()) {
                return;
            }
            me.addToContainers(slot);
        } else if (!(this.useContainment && this.discardContainerRefs && meNode.isContainer(ref.getKey()))) {
            ReferenceSlot slot = this.encodeReferenceSlot(meNode, ref);
            if (slot.ids.isEmpty()) {
                return;
            }
            me.addToReferences(slot);
        }
    }

    private ContainerSlot encodeContainerSlot(ModelElementNode sourceNode, Map.Entry<String, Object> slotEntry) throws Exception {
        assert (slotEntry.getValue() != null);
        ContainerSlot s = new ContainerSlot();
        s.name = slotEntry.getKey();
        Object value = slotEntry.getValue();
        if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                ModelElementNode meNode = this.graph.getModelElementNodeById(sourceNode, o);
                ModelElement me = this.encode(meNode);
                if (me == null) continue;
                s.addToElements(me);
                this.rootElements.remove(me);
            }
        } else {
            ModelElementNode meNode = this.graph.getModelElementNodeById(sourceNode, value);
            ModelElement me = this.encode(meNode);
            if (me != null) {
                s.addToElements(me);
                this.rootElements.remove(me);
            }
        }
        return s;
    }

    private ReferenceSlot encodeReferenceSlot(ModelElementNode sourceNode, Map.Entry<String, Object> slotEntry) throws Exception {
        assert (slotEntry.getValue() != null);
        ReferenceSlot slot = new ReferenceSlot();
        slot.name = slotEntry.getKey();
        Object value = slotEntry.getValue();
        slot.ids = new ArrayList();
        if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                this.addToReferenceIds(sourceNode, o, slot);
            }
        } else {
            this.addToReferenceIds(sourceNode, value, slot);
        }
        return slot;
    }

    private void addToReferenceIds(ModelElementNode sourceNode, Object o, ReferenceSlot s) throws Exception {
        ModelElementNode meNode;
        if (o instanceof IGraphNode) {
            meNode = new ModelElementNode((IGraphNode)o);
        } else {
            String referenceId = o.toString();
            meNode = this.graph.getModelElementNodeById(sourceNode, (Object)referenceId);
        }
        if (this.isEncodable(meNode)) {
            s.addToIds(meNode.getNodeId());
        }
    }

    public static AttributeSlot encodeAttributeSlot(String name, Object rawValue) {
        assert (rawValue != null);
        SlotValue value = HawkModelElementEncoder.encodeSlotValue(rawValue);
        AttributeSlot slot = new AttributeSlot(name);
        if (value != null) {
            slot.setValue(value);
        }
        return slot;
    }

    protected static SlotValue encodeSlotValue(Object rawValue) {
        SlotValue value = new SlotValue();
        if (rawValue instanceof Object[]) {
            rawValue = Arrays.asList((Object[])rawValue);
        }
        if (rawValue instanceof Collection) {
            Collection cValue = rawValue;
            int cSize = cValue.size();
            if (cSize == 1) {
                HawkModelElementEncoder.encodeSingleValueAttributeSlot(value, cValue.iterator().next());
            } else if (cSize > 0) {
                value = new SlotValue();
                HawkModelElementEncoder.encodeNonEmptyListAttributeSlot(value, rawValue, cValue);
            } else {
                value = null;
            }
        } else {
            HawkModelElementEncoder.encodeSingleValueAttributeSlot(value, rawValue);
        }
        if (value != null && !value.isSet()) {
            throw new IllegalArgumentException(String.format("Unsupported value type '%s'", rawValue.getClass().getName()));
        }
        return value;
    }

    private static void encodeSingleValueAttributeSlot(SlotValue value, Object rawValue) {
        if (rawValue instanceof Byte) {
            value.setVByte(((Byte)rawValue).byteValue());
        } else if (rawValue instanceof Float) {
            value.setVDouble(((Double)rawValue).doubleValue());
        } else if (rawValue instanceof Double) {
            value.setVDouble(((Double)rawValue).doubleValue());
        } else if (rawValue instanceof Integer) {
            value.setVInteger(((Integer)rawValue).intValue());
        } else if (rawValue instanceof Long) {
            value.setVLong(((Long)rawValue).longValue());
        } else if (rawValue instanceof Short) {
            value.setVShort(((Short)rawValue).shortValue());
        } else if (rawValue instanceof String) {
            value.setVString((String)rawValue);
        } else if (rawValue instanceof Boolean) {
            value.setVBoolean(((Boolean)rawValue).booleanValue());
        }
    }

    private static void encodeNonEmptyListAttributeSlot(SlotValue value, Object rawValue, Collection<?> cValue) {
        Iterator<?> it = cValue.iterator();
        Object o = it.next();
        if (o instanceof Byte) {
            ByteBuffer bbuf = ByteBuffer.allocate(cValue.size());
            bbuf.put((Byte)o);
            while (it.hasNext()) {
                bbuf.put((Byte)it.next());
            }
            bbuf.flip();
            value.setVBytes(bbuf);
        } else if (o instanceof Float) {
            ArrayList<Double> l = new ArrayList<Double>(cValue.size());
            l.add((Double)o);
            while (it.hasNext()) {
                l.add((Double)it.next());
            }
            value.setVDoubles(l);
        } else if (o instanceof Double) {
            value.setVDoubles(new ArrayList(cValue));
        } else if (o instanceof Integer) {
            value.setVIntegers(new ArrayList(cValue));
        } else if (o instanceof Long) {
            value.setVLongs(new ArrayList(cValue));
        } else if (o instanceof Short) {
            value.setVShorts(new ArrayList(cValue));
        } else if (o instanceof String) {
            value.setVStrings(new ArrayList(cValue));
        } else if (o instanceof Boolean) {
            value.setVBooleans(new ArrayList(cValue));
        } else if (o instanceof Collection) {
            ArrayList<SlotValue> values = new ArrayList<SlotValue>();
            for (Object e : (Collection)o) {
                value = HawkModelElementEncoder.encodeSlotValue(e);
                values.add(value);
            }
            value.setVLists(values);
        } else {
            if (o != null) {
                throw new IllegalArgumentException(String.format("Unsupported element type '%s'", rawValue.getClass().getName()));
            }
            throw new IllegalArgumentException("Null values inside collections are not allowed");
        }
    }
}

