/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.epl.EplModule;
import org.eclipse.epsilon.epl.execute.PatternMatch;
import org.eclipse.epsilon.epl.execute.model.PatternMatchModel;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.query.QueryExecutionException;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.tracking.AccessListener;

public class EPLQueryEngine
extends EOLQueryEngine {
    public static final String TYPE = "org.eclipse.hawk.epsilon.emc.EPLQueryEngine";
    public static final String RULENAME_KEY = "_rulename";

    @Override
    public AccessListener calculateDerivedAttributes(IModelIndexer m, Iterable<IGraphNode> nodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected IEolModule createModule() {
        return new EplModule();
    }

    @Override
    protected Object runQuery(IEolModule module) throws QueryExecutionException {
        Object ret = super.runQuery(module);
        if (ret instanceof PatternMatchModel) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (PatternMatchModel matchModel = (PatternMatchModel)ret;){
                ArrayList results = new ArrayList(matchModel.getMatches().size());
                for (PatternMatch match : matchModel.getMatches()) {
                    HashMap<String, String> result = new HashMap<String, String>(match.getRoleBindings());
                    result.put(RULENAME_KEY, match.getPattern().getName());
                    results.add(result);
                }
                return results;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return ret;
    }

    @Override
    public String getHumanReadableName() {
        return "EPL Query Engine";
    }
}

