/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.util.IndexedAttributeParameters;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.osgiserver.HModelSchedulingRule;
import org.eclipse.hawk.ui2.Activator;
import org.eclipse.hawk.ui2.dialog.HDerivedAttributeDialog;
import org.eclipse.hawk.ui2.dialog.HIndexedAttributeDialog;
import org.eclipse.hawk.ui2.dialog.HVCSDialog;
import org.eclipse.hawk.ui2.mmselectors.IHawkMetaModelResourceSelector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.FrameworkUtil;

public class HConfigDialog
extends TitleAreaDialog
implements IStateListener {
    private static final String ERROR_MM_REGISTRATION = "Error while registering metamodels";
    private static final String DEFAULT_MESSAGE = "Manage metamodels, locations and indexed/derived attributes in the indexer.";
    HModel hawkModel;
    private org.eclipse.swt.widgets.List metamodelList;
    private org.eclipse.swt.widgets.List derivedAttributeList;
    private org.eclipse.swt.widgets.List indexedAttributeList;
    private org.eclipse.swt.widgets.List indexList;
    private ListViewer lstVCSLocations;
    private Button indexRefreshButton;
    private Button removeDerivedAttributeButton;
    private Button addDerivedAttributeButton;
    private Button removeIndexedAttributeButton;
    private Button addIndexedAttributeButton;
    private Button removeMetaModelsButton;
    private List<Button> addMetaModelsButtons;
    private Button addVCSButton;
    private Button editVCSButton;
    private Button removeVCSButton;
    IStateListener.HawkState hawkState;

    public HConfigDialog(Shell parentShell, HModel in) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() & 0xFFFFFFBF);
        this.hawkModel = in;
        this.hawkModel.getHawk().getModelIndexer().addStateListener((IStateListener)this);
    }

    private Composite allIndexesTab(TabFolder parent) {
        Composite composite = new Composite((Composite)parent, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.indexList = new org.eclipse.swt.widgets.List(composite, 2816);
        GridData gridDataQ = new GridData();
        gridDataQ.grabExcessHorizontalSpace = true;
        gridDataQ.horizontalAlignment = 4;
        gridDataQ.heightHint = 300;
        gridDataQ.widthHint = 600;
        gridDataQ.horizontalSpan = 2;
        this.indexList.setLayoutData((Object)gridDataQ);
        this.updateAllIndexesList();
        this.indexRefreshButton = new Button(composite, 0);
        this.indexRefreshButton.setText("Refresh");
        this.indexRefreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HConfigDialog.this.updateAllIndexesList();
            }
        });
        return composite;
    }

    private void derivedAttributeAdd() {
        HDerivedAttributeDialog d = new HDerivedAttributeDialog(this.hawkModel, this.getShell());
        d.setBlockOnOpen(true);
        if (d.open() == 0) {
            this.updateDerivedAttributeList();
        }
    }

    private Composite derivedAttributeTab(TabFolder parent) {
        Composite composite = new Composite((Composite)parent, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.derivedAttributeList = new org.eclipse.swt.widgets.List(composite, 2818);
        GridData gridDataQ = new GridData();
        gridDataQ.grabExcessHorizontalSpace = true;
        gridDataQ.horizontalAlignment = 4;
        gridDataQ.heightHint = 300;
        gridDataQ.widthHint = 600;
        gridDataQ.horizontalSpan = 2;
        this.derivedAttributeList.setLayoutData((Object)gridDataQ);
        this.derivedAttributeList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean running = HConfigDialog.this.hawkState == IStateListener.HawkState.RUNNING;
                HConfigDialog.this.removeDerivedAttributeButton.setEnabled(running && HConfigDialog.this.derivedAttributeList.getSelection().length > 0);
            }
        });
        this.updateDerivedAttributeList();
        this.removeDerivedAttributeButton = new Button(composite, 8);
        this.removeDerivedAttributeButton.setText("Remove");
        this.removeDerivedAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final String[] selected = HConfigDialog.this.derivedAttributeList.getSelection();
                if (selected.length > 0) {
                    MessageBox messageBox = new MessageBox(HConfigDialog.this.getShell(), 196);
                    messageBox.setMessage("Are you sure you wish to delete the chosen derived attributes?");
                    messageBox.setText("Indexed Attribute deletion");
                    if (messageBox.open() == 64) {
                        Job removeDerivedJob = new Job("Removing derived attribute from " + HConfigDialog.this.hawkModel.getName()){

                            protected IStatus run(IProgressMonitor monitor) {
                                (this).HConfigDialog.this.hawkModel.removeDerivedAttributes(selected);
                                Display.getDefault().asyncExec(() -> HConfigDialog.access$3(HConfigDialog.this));
                                return new Status(0, HConfigDialog.this.getBundleName(), "Done");
                            }
                        };
                        removeDerivedJob.setRule((ISchedulingRule)new HModelSchedulingRule(HConfigDialog.this.hawkModel));
                        removeDerivedJob.schedule();
                    }
                }
            }
        });
        this.addDerivedAttributeButton = new Button(composite, 0);
        this.addDerivedAttributeButton.setText("Add...");
        this.addDerivedAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HConfigDialog.this.derivedAttributeAdd();
            }
        });
        return composite;
    }

    private void indexedAttributeAdd() {
        HIndexedAttributeDialog d = new HIndexedAttributeDialog(this.hawkModel, this.getShell());
        d.setBlockOnOpen(true);
        if (d.open() == 0) {
            this.updateIndexedAttributeList();
        }
    }

    private Composite indexedAttributeTab(TabFolder parent) {
        Composite composite = new Composite((Composite)parent, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.indexedAttributeList = new org.eclipse.swt.widgets.List(composite, 2818);
        GridData gridDataQ = new GridData();
        gridDataQ.grabExcessHorizontalSpace = true;
        gridDataQ.horizontalAlignment = 4;
        gridDataQ.heightHint = 300;
        gridDataQ.widthHint = 600;
        gridDataQ.horizontalSpan = 2;
        this.indexedAttributeList.setLayoutData((Object)gridDataQ);
        this.indexedAttributeList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean running = HConfigDialog.this.hawkState == IStateListener.HawkState.RUNNING;
                HConfigDialog.this.removeIndexedAttributeButton.setEnabled(running && HConfigDialog.this.indexedAttributeList.getSelection().length > 0);
            }
        });
        this.updateIndexedAttributeList();
        this.removeIndexedAttributeButton = new Button(composite, 8);
        this.removeIndexedAttributeButton.setText("Remove");
        this.removeIndexedAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final String[] selected = HConfigDialog.this.indexedAttributeList.getSelection();
                if (selected.length > 0) {
                    MessageBox messageBox = new MessageBox(HConfigDialog.this.getShell(), 196);
                    messageBox.setMessage("Are you sure you wish to delete the chosen indexed attributes?");
                    messageBox.setText("Indexed Attribute deletion");
                    if (messageBox.open() == 64) {
                        Job removeIndexedJob = new Job("Removing indexed attribute from " + HConfigDialog.this.hawkModel.getName()){

                            protected IStatus run(IProgressMonitor monitor) {
                                (this).HConfigDialog.this.hawkModel.removeIndexedAttributes(selected);
                                Display.getDefault().asyncExec(() -> HConfigDialog.access$8(HConfigDialog.this));
                                return new Status(0, HConfigDialog.this.getBundleName(), "Done");
                            }
                        };
                        removeIndexedJob.setRule((ISchedulingRule)new HModelSchedulingRule(HConfigDialog.this.hawkModel));
                        removeIndexedJob.schedule();
                    }
                }
            }
        });
        this.addIndexedAttributeButton = new Button(composite, 0);
        this.addIndexedAttributeButton.setText("Add...");
        this.addIndexedAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HConfigDialog.this.indexedAttributeAdd();
            }
        });
        return composite;
    }

    private Composite metamodelsTab(TabFolder parent) {
        Composite composite = new Composite((Composite)parent, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        this.metamodelList = new org.eclipse.swt.widgets.List(composite, 2818);
        GridData gridDataQ = new GridData();
        gridDataQ.grabExcessHorizontalSpace = true;
        gridDataQ.horizontalAlignment = 4;
        gridDataQ.heightHint = 300;
        gridDataQ.widthHint = 600;
        gridDataQ.horizontalSpan = 3;
        this.metamodelList.setLayoutData((Object)gridDataQ);
        this.updateMetamodelList();
        this.removeMetaModelsButton = new Button(composite, 8);
        this.removeMetaModelsButton.setText("Remove");
        this.removeMetaModelsButton.setEnabled(this.hawkState == IStateListener.HawkState.RUNNING);
        this.removeMetaModelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final String[] selectedMetamodel = HConfigDialog.this.metamodelList.getSelection();
                if (selectedMetamodel.length > 0) {
                    MessageBox messageBox = new MessageBox(HConfigDialog.this.getShell(), 196);
                    messageBox.setMessage("Are you sure you wish to delete the chosen metamodel(s)? This will also delete any dependant metamodels/models and may take a long time to complete.");
                    messageBox.setText("Metamodel deletion");
                    int response = messageBox.open();
                    if (response == 64) {
                        Job removeMetamodelJob = new Job("Removing metamodel from " + HConfigDialog.this.hawkModel.getName()){

                            protected IStatus run(IProgressMonitor monitor) {
                                (this).HConfigDialog.this.hawkModel.removeMetamodels(selectedMetamodel);
                                Display.getDefault().asyncExec(() -> HConfigDialog.access$11(HConfigDialog.this));
                                return new Status(0, HConfigDialog.this.getBundleName(), "Done");
                            }
                        };
                        removeMetamodelJob.setRule((ISchedulingRule)new HModelSchedulingRule(HConfigDialog.this.hawkModel));
                        removeMetamodelJob.schedule();
                    }
                }
            }
        });
        Composite cmpAddButtons = new Composite(composite, 0);
        cmpAddButtons.setLayout((Layout)new RowLayout());
        Map<String, IHawkMetaModelResourceSelector> selectors = this.getMetamodelSelectors();
        this.addMetaModelsButtons = new ArrayList<Button>(selectors.size());
        for (Map.Entry<String, IHawkMetaModelResourceSelector> entry : selectors.entrySet()) {
            String name = entry.getKey();
            final IHawkMetaModelResourceSelector selector = entry.getValue();
            Button selectorButton = new Button(cmpAddButtons, 8);
            selectorButton.setText(name);
            this.addMetaModelsButtons.add(selectorButton);
            selectorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        selector.selectMetamodels(HConfigDialog.this.getShell(), HConfigDialog.this.hawkModel.getIndexer());
                        HConfigDialog.this.updateMetamodelList();
                    }
                    catch (Exception exSelect) {
                        MessageDialog.openError((Shell)HConfigDialog.this.getParentShell(), (String)HConfigDialog.ERROR_MM_REGISTRATION, (String)exSelect.getMessage());
                        Activator.logError(HConfigDialog.ERROR_MM_REGISTRATION, exSelect);
                    }
                }
            });
        }
        return composite;
    }

    private Map<String, IHawkMetaModelResourceSelector> getMetamodelSelectors() {
        TreeMap<String, IHawkMetaModelResourceSelector> selectors = new TreeMap<String, IHawkMetaModelResourceSelector>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hawk.ui.metamodelSelector");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            String name = e.getAttribute("buttonText");
            try {
                IHawkMetaModelResourceSelector selector = (IHawkMetaModelResourceSelector)e.createExecutableExtension("class");
                if (selector.isApplicableTo(this.hawkModel.getIndexer())) {
                    selectors.put(name, selector);
                }
            }
            catch (CoreException ex) {
                Activator.logError("Could not add the selector " + name + " to the UI", ex);
            }
            ++n2;
        }
        return selectors;
    }

    private void updateAllIndexesList() {
        this.indexList.removeAll();
        for (String i : this.hawkModel.getIndexes()) {
            this.indexList.add(i);
        }
        Object[] items = this.indexList.getItems();
        Arrays.sort(items);
        this.indexList.setItems((String[])items);
    }

    private void updateDerivedAttributeList() {
        if (this.derivedAttributeList.isDisposed()) {
            return;
        }
        this.derivedAttributeList.removeAll();
        for (IndexedAttributeParameters da : this.hawkModel.getDerivedAttributes()) {
            this.derivedAttributeList.add(String.format("%s##%s##%s", da.getMetamodelUri(), da.getTypeName(), da.getAttributeName()));
        }
        Object[] items = this.derivedAttributeList.getItems();
        Arrays.sort(items);
        this.derivedAttributeList.setItems((String[])items);
    }

    private void updateIndexedAttributeList() {
        if (this.indexedAttributeList.isDisposed()) {
            return;
        }
        this.indexedAttributeList.removeAll();
        for (IndexedAttributeParameters ia : this.hawkModel.getIndexedAttributes()) {
            this.indexedAttributeList.add(String.format("%s##%s##%s", ia.getMetamodelUri(), ia.getTypeName(), ia.getAttributeName()));
        }
        Object[] items = this.indexedAttributeList.getItems();
        Arrays.sort(items);
        this.indexedAttributeList.setItems((String[])items);
    }

    private void updateMetamodelList() {
        if (this.metamodelList.isDisposed()) {
            return;
        }
        this.metamodelList.removeAll();
        List mms = this.hawkModel.getRegisteredMetamodels();
        Collections.sort(mms);
        for (String mm : mms) {
            this.metamodelList.add(mm);
        }
    }

    private Composite vcsTab(TabFolder parent) {
        Composite composite = new Composite((Composite)parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.lstVCSLocations = new ListViewer(composite, 2816);
        this.lstVCSLocations.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IVcsManager)element).getLocation();
            }
        });
        this.lstVCSLocations.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.lstVCSLocations.setInput((Object)this.hawkModel.getRunningVCSManagers().toArray());
        GridData lstVCSLocationsLayoutData = new GridData(4, 4, true, true);
        lstVCSLocationsLayoutData.horizontalSpan = 3;
        this.lstVCSLocations.getList().setLayoutData((Object)lstVCSLocationsLayoutData);
        this.editVCSButton = new Button(composite, 0);
        this.editVCSButton.setText("Edit...");
        this.editVCSButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new HVCSDialog(HConfigDialog.this.getShell(), HConfigDialog.this.hawkModel, HConfigDialog.this.getSelectedExistingVCSManager()).open();
                HConfigDialog.this.lstVCSLocations.refresh();
            }
        });
        this.editVCSButton.setEnabled(false);
        this.removeVCSButton = new Button(composite, 0);
        this.removeVCSButton.setText("Remove");
        this.removeVCSButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final IVcsManager m = HConfigDialog.this.getSelectedExistingVCSManager();
                if (m != null) {
                    MessageBox messageBox = new MessageBox(HConfigDialog.this.getShell(), 196);
                    messageBox.setMessage("Are you sure you wish to remove the chosen VCS location? This will also delete all indexed models from it, and may take a long time to complete in the background.");
                    messageBox.setText("VCS location deletion");
                    if (messageBox.open() == 64) {
                        Job removeVcsJob = new Job("Removing VCS from " + HConfigDialog.this.hawkModel.getName()){

                            protected IStatus run(IProgressMonitor monitor) {
                                try {
                                    (this).HConfigDialog.this.hawkModel.removeRepository(m);
                                }
                                catch (Exception ee) {
                                    return new Status(4, HConfigDialog.this.getBundleName(), "Failed to remove VCS", (Throwable)ee);
                                }
                                Display.getDefault().asyncExec(() -> {
                                    if (HConfigDialog.this.lstVCSLocations.getControl() != null && !HConfigDialog.this.lstVCSLocations.getControl().isDisposed()) {
                                        HConfigDialog.this.lstVCSLocations.setInput((Object)(this).HConfigDialog.this.hawkModel.getRunningVCSManagers().toArray());
                                    }
                                });
                                return new Status(0, HConfigDialog.this.getBundleName(), "Removed VCS");
                            }
                        };
                        removeVcsJob.setRule((ISchedulingRule)new HModelSchedulingRule(HConfigDialog.this.hawkModel));
                        removeVcsJob.schedule();
                    }
                }
            }
        });
        this.removeVCSButton.setEnabled(false);
        this.addVCSButton = new Button(composite, 0);
        this.addVCSButton.setText("Add...");
        this.addVCSButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new HVCSDialog(HConfigDialog.this.getShell(), HConfigDialog.this.hawkModel, null).open();
                HConfigDialog.this.lstVCSLocations.setInput((Object)HConfigDialog.this.hawkModel.getRunningVCSManagers().toArray());
            }
        });
        this.lstVCSLocations.getList().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean running = HConfigDialog.this.hawkState == IStateListener.HawkState.RUNNING;
                HConfigDialog.this.editVCSButton.setEnabled(running && HConfigDialog.this.getSelectedExistingVCSManager() != null);
                HConfigDialog.this.removeVCSButton.setEnabled(running && HConfigDialog.this.getSelectedExistingVCSManager() != null);
            }
        });
        return composite;
    }

    protected IVcsManager getSelectedExistingVCSManager() {
        IStructuredSelection sel = (IStructuredSelection)this.lstVCSLocations.getSelection();
        if (sel.isEmpty()) {
            return null;
        }
        return (IVcsManager)sel.getFirstElement();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Configure Indexer: " + this.hawkModel.getName());
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 1) {
            return null;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button done = this.getButton(0);
        done.setText("Done");
        this.setButtonLayoutData(done);
    }

    protected Control createDialogArea(Composite parent) {
        try {
            HConfigDialog.setDefaultImage((Image)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("hawk.ui.view.HawkView").getTitleImage());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        TabFolder tabFolder = new TabFolder(parent, 2048);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem metamodelTab = new TabItem(tabFolder, 0);
        metamodelTab.setText("Metamodels");
        metamodelTab.setControl((Control)this.metamodelsTab(tabFolder));
        TabItem vcsTab = new TabItem(tabFolder, 0);
        vcsTab.setText("Indexed Locations");
        vcsTab.setControl((Control)this.vcsTab(tabFolder));
        TabItem derivedAttributeTab = new TabItem(tabFolder, 0);
        derivedAttributeTab.setText("Derived Attributes");
        derivedAttributeTab.setControl((Control)this.derivedAttributeTab(tabFolder));
        TabItem indexedAttributeTab = new TabItem(tabFolder, 0);
        indexedAttributeTab.setText("Indexed Attributes");
        indexedAttributeTab.setControl((Control)this.indexedAttributeTab(tabFolder));
        TabItem allIndexesTab = new TabItem(tabFolder, 0);
        allIndexesTab.setText("All indexes");
        allIndexesTab.setControl((Control)this.allIndexesTab(tabFolder));
        tabFolder.pack();
        this.setTitle("Configuration for indexer " + this.hawkModel.getName());
        this.setMessage(DEFAULT_MESSAGE);
        return tabFolder;
    }

    public boolean close() {
        this.hawkModel.getHawk().getModelIndexer().removeStateListener((IStateListener)this);
        return super.close();
    }

    public void state(IStateListener.HawkState state) {
        this.updateAsync(state);
    }

    public void info(String s) {
    }

    public void error(String s) {
    }

    public void removed() {
    }

    public void updateAsync(final IStateListener.HawkState s) {
        if (this.hawkState == s) {
            return;
        }
        this.hawkState = s;
        Shell shell = this.getShell();
        if (shell == null) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean running = s == IStateListener.HawkState.RUNNING;
                    HConfigDialog.this.indexRefreshButton.setEnabled(running);
                    HConfigDialog.this.removeDerivedAttributeButton.setEnabled(running);
                    HConfigDialog.this.addDerivedAttributeButton.setEnabled(running);
                    HConfigDialog.this.removeIndexedAttributeButton.setEnabled(running);
                    HConfigDialog.this.addIndexedAttributeButton.setEnabled(running);
                    HConfigDialog.this.removeMetaModelsButton.setEnabled(running);
                    HConfigDialog.this.addMetaModelsButtons.forEach(b -> b.setEnabled(running));
                    HConfigDialog.this.addVCSButton.setEnabled(running);
                    HConfigDialog.this.editVCSButton.setEnabled(running && HConfigDialog.this.getSelectedExistingVCSManager() != null);
                    if (running) {
                        HConfigDialog.this.setErrorMessage(null);
                    } else {
                        HConfigDialog.this.setErrorMessage(String.format("The index is %s - some buttons will be disabled", s.toString().toLowerCase()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private String getBundleName() {
        return FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName();
    }

    static /* synthetic */ void access$3(HConfigDialog hConfigDialog) {
        hConfigDialog.updateDerivedAttributeList();
    }

    static /* synthetic */ void access$8(HConfigDialog hConfigDialog) {
        hConfigDialog.updateIndexedAttributeList();
    }

    static final class VCSLabelProvider
    extends LabelProvider {
        VCSLabelProvider() {
        }

        public String getText(Object element) {
            return ((IVcsManager)element).getHumanReadableName();
        }
    }
}

