/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime.augmentation;

import java.lang.reflect.Method;
import java.util.Objects;
import org.eclipse.golo.runtime.augmentation.AugmentationApplication;
import org.eclipse.golo.runtime.augmentation.DefiningModule;

public final class AugmentationMethod
implements Comparable<AugmentationMethod> {
    private final AugmentationApplication.Kind kind;
    private final DefiningModule.Scope scope;
    private final Class<?> target;
    private final Method method;

    AugmentationMethod(AugmentationApplication.Kind kind, DefiningModule.Scope scope, Class<?> target, Method method) {
        this.kind = kind;
        this.scope = scope;
        this.target = target;
        this.method = method;
    }

    public Method method() {
        return this.method;
    }

    public String toString() {
        return String.format("AugmentationMethod<%s,%s,%s,%s>", new Object[]{this.kind, this.scope, this.target, this.method});
    }

    @Override
    public int compareTo(AugmentationMethod other) {
        if (this.target.isAssignableFrom(other.target) && !this.target.equals(other.target)) {
            return 1;
        }
        if (other.target.isAssignableFrom(this.target) && !this.target.equals(other.target)) {
            return -1;
        }
        if (this.scope != other.scope) {
            return this.scope.compareTo(other.scope);
        }
        if (this.kind != other.kind) {
            return this.kind.compareTo(other.kind);
        }
        if (this.method.isVarArgs() && !other.method.isVarArgs()) {
            return 1;
        }
        if (other.method.isVarArgs() && !this.method.isVarArgs()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        AugmentationMethod that = (AugmentationMethod)o;
        return this.kind == that.kind && this.scope == that.scope && this.target.equals(that.target) && this.method.equals(that.method);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.scope, this.target, this.method});
    }
}

