/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.golo.doc.DocumentationElement;
import org.eclipse.golo.doc.FunctionDocumentation;

class AugmentationDocumentation
extends AbstractSet<FunctionDocumentation>
implements SortedSet<FunctionDocumentation>,
DocumentationElement {
    private String target;
    private String documentation;
    private int line;
    private DocumentationElement parent;
    private final SortedSet<FunctionDocumentation> functions = new TreeSet<FunctionDocumentation>();
    private final List<String> augmentationNames = new LinkedList<String>();

    AugmentationDocumentation() {
    }

    @Override
    public String type() {
        return "augmentation";
    }

    public String target() {
        return this.target;
    }

    public AugmentationDocumentation target(String target) {
        this.target = target;
        return this;
    }

    @Override
    public String name() {
        return this.target();
    }

    @Override
    public String id() {
        return "augment." + this.name();
    }

    @Override
    public DocumentationElement parent() {
        return this.parent;
    }

    public AugmentationDocumentation parent(DocumentationElement p) {
        this.parent = p;
        return this;
    }

    @Override
    public String documentation() {
        return this.documentation != null ? this.documentation : "\n";
    }

    public AugmentationDocumentation documentation(String documentation) {
        if (documentation != null && !documentation.isEmpty()) {
            this.documentation = documentation;
        }
        return this;
    }

    @Override
    public int line() {
        return this.line;
    }

    public AugmentationDocumentation line(int line) {
        this.line = line;
        return this;
    }

    public SortedSet<FunctionDocumentation> functions() {
        return Collections.unmodifiableSortedSet(this.functions);
    }

    public AugmentationDocumentation functions(Collection<FunctionDocumentation> docs) {
        if (docs != null) {
            this.functions.addAll(docs);
        }
        return this;
    }

    public List<String> augmentationNames() {
        return Collections.unmodifiableList(this.augmentationNames);
    }

    public AugmentationDocumentation augmentationNames(Collection<String> names) {
        if (names != null) {
            this.augmentationNames.addAll(names);
        }
        return this;
    }

    @Override
    public boolean add(FunctionDocumentation func) {
        return this.functions.add(func);
    }

    @Override
    public int size() {
        return this.functions.size();
    }

    @Override
    public Iterator<FunctionDocumentation> iterator() {
        return this.functions.iterator();
    }

    @Override
    public FunctionDocumentation last() {
        return this.functions.last();
    }

    @Override
    public FunctionDocumentation first() {
        return this.functions.first();
    }

    @Override
    public SortedSet<FunctionDocumentation> headSet(FunctionDocumentation e) {
        return this.functions.headSet(e);
    }

    @Override
    public SortedSet<FunctionDocumentation> tailSet(FunctionDocumentation e) {
        return this.functions.tailSet(e);
    }

    @Override
    public SortedSet<FunctionDocumentation> subSet(FunctionDocumentation f, FunctionDocumentation t) {
        return this.functions.subSet(f, t);
    }

    @Override
    public Comparator<? super FunctionDocumentation> comparator() {
        return this.functions.comparator();
    }
}

