/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import gololang.ir.AbstractGoloIrVisitor;
import gololang.ir.AssignmentStatement;
import gololang.ir.BinaryOperation;
import gololang.ir.Block;
import gololang.ir.BlockContainer;
import gololang.ir.CaseStatement;
import gololang.ir.ClassReference;
import gololang.ir.ClosureReference;
import gololang.ir.CollectionComprehension;
import gololang.ir.CollectionLiteral;
import gololang.ir.ConditionalBranching;
import gololang.ir.ConstantStatement;
import gololang.ir.DestructuringAssignment;
import gololang.ir.ExpressionStatement;
import gololang.ir.ForEachLoopStatement;
import gololang.ir.FunctionContainer;
import gololang.ir.FunctionInvocation;
import gololang.ir.FunctionRef;
import gololang.ir.GoloAssignment;
import gololang.ir.GoloElement;
import gololang.ir.GoloFunction;
import gololang.ir.GoloModule;
import gololang.ir.GoloStatement;
import gololang.ir.LocalReference;
import gololang.ir.LoopStatement;
import gololang.ir.MatchExpression;
import gololang.ir.MethodInvocation;
import gololang.ir.ReferenceLookup;
import gololang.ir.ReturnStatement;
import gololang.ir.Struct;
import gololang.ir.UnaryOperation;
import gololang.ir.WhenClause;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.golo.compiler.SymbolGenerator;

class SugarExpansionVisitor
extends AbstractGoloIrVisitor {
    private final SymbolGenerator symbols = new SymbolGenerator("golo.compiler.sugar");
    private final List<GoloFunction> functionsToAdd = new LinkedList<GoloFunction>();
    private GoloModule module;

    SugarExpansionVisitor() {
    }

    @Override
    public void visitModule(GoloModule module) {
        this.module = module;
        module.walk(this);
        for (GoloFunction f : this.functionsToAdd) {
            module.addFunction(f);
        }
    }

    @Override
    public void visitBlock(Block block) {
        this.visitExpression(block);
        block.flatten();
    }

    @Override
    public void visitClosureReference(ClosureReference closure) {
        this.functionsToAdd.add(closure.getTarget().name(this.symbols.next("closure")));
        this.visitExpression(closure);
    }

    @Override
    public void visitFunction(GoloFunction function) {
        function.insertMissingReturnStatement();
        if (!this.expressionToBlock(function)) {
            function.walk(this);
            if (function.isDecorated() && function.hasParent()) {
                FunctionContainer parent = (FunctionContainer)((Object)function.parent());
                GoloFunction decorator = function.createDecorator();
                parent.addFunction(decorator);
                decorator.accept(this);
            }
            function.insertMissingReturnStatement();
        }
    }

    @Override
    public void visitCaseStatement(CaseStatement caseStatement) {
        ConditionalBranching branch = this.convertCaseToConditional(caseStatement);
        caseStatement.replaceInParentBy(branch);
        branch.accept(this);
    }

    private ConditionalBranching convertCaseToConditional(CaseStatement caseStatement) {
        LinkedList<WhenClause<Block>> clauses = new LinkedList<WhenClause<Block>>(caseStatement.getClauses());
        WhenClause lastClause = (WhenClause)clauses.removeLast();
        ConditionalBranching branch = (ConditionalBranching)ConditionalBranching.branch().condition(lastClause.condition()).whenTrue(lastClause.action()).whenFalse(caseStatement.getOtherwise()).positionInSourceCode(lastClause.positionInSourceCode());
        while (!clauses.isEmpty()) {
            lastClause = (WhenClause)clauses.removeLast();
            branch = (ConditionalBranching)ConditionalBranching.branch().condition(lastClause.condition()).whenTrue(lastClause.action()).elseBranch(branch).positionInSourceCode(lastClause.positionInSourceCode());
        }
        return branch;
    }

    @Override
    public void visitMatchExpression(MatchExpression matchExpression) {
        LocalReference tempVar = LocalReference.of(this.symbols.next("match")).variable().synthetic();
        Block converted = SugarExpansionVisitor.convertMatchToBlock(matchExpression, e -> AssignmentStatement.create(tempVar, e, false));
        converted.prepend(AssignmentStatement.create(tempVar, ConstantStatement.of(null), true));
        converted.add(tempVar.lookup());
        matchExpression.replaceInParentBy(converted);
        converted.accept(this);
    }

    private static Block convertMatchToBlock(MatchExpression matchExpression, Function<ExpressionStatement<?>, ? extends GoloStatement<?>> mapping) {
        Block converted = Block.empty();
        for (GoloAssignment<?> a : matchExpression.declarations()) {
            converted.add(a);
        }
        matchExpression.clearDeclarations();
        converted.add(SugarExpansionVisitor.convertMatchToMappedCase(matchExpression, mapping));
        return converted;
    }

    private static CaseStatement convertMatchToMappedCase(MatchExpression matchExpression, Function<ExpressionStatement<?>, ? extends GoloStatement<?>> mapping) {
        CaseStatement caseStatement = CaseStatement.cases().otherwise(Block.of(mapping.apply((ExpressionStatement<?>)matchExpression.getOtherwise())));
        for (WhenClause<ExpressionStatement<?>> c : matchExpression.getClauses()) {
            caseStatement.when(c.condition()).then(mapping.apply(c.action()).positionInSourceCode(c.action().positionInSourceCode())).positionInSourceCode(c.positionInSourceCode());
        }
        return caseStatement;
    }

    @Override
    public void visitReturnStatement(ReturnStatement ret) {
        if (ret.expression() instanceof MatchExpression) {
            MatchExpression matchExpression = (MatchExpression)ret.expression();
            Block converted = SugarExpansionVisitor.convertMatchToBlock(matchExpression, ReturnStatement::of);
            ret.replaceInParentBy(converted);
            converted.accept(this);
        } else {
            super.visitReturnStatement(ret);
        }
    }

    @Override
    public void visitCollectionLiteral(CollectionLiteral collection) {
        if (!this.expressionToBlock(collection)) {
            collection.walk(this);
            FunctionInvocation construct = FunctionInvocation.of("gololang.Predefined." + collection.getType().toString()).withArgs(collection.getExpressions().toArray());
            collection.replaceInParentBy(construct);
            ((GoloElement)construct).accept(this);
        }
    }

    @Override
    public void visitConstantStatement(ConstantStatement constantStatement) {
        constantStatement.walk(this);
        Object value = constantStatement.value();
        if (value instanceof FunctionRef) {
            FunctionInvocation fun = this.literalFunctionRefToCall((FunctionRef)value);
            constantStatement.replaceInParentBy(fun);
            fun.accept(this);
        }
    }

    private FunctionInvocation literalFunctionRefToCall(FunctionRef ref) {
        return FunctionInvocation.of("gololang.Predefined.fun").constant().withArgs(ConstantStatement.of(ref.name()), ConstantStatement.of(ClassReference.of(ref.module() == null ? this.module.getPackageAndClass() : ref.module())), ConstantStatement.of(ref.arity()), ConstantStatement.of(ref.varargs()));
    }

    @Override
    public void visitCollectionComprehension(CollectionComprehension collection) {
        CollectionLiteral.Type tempColType = collection.getMutableType();
        LocalReference tempVar = LocalReference.of(this.symbols.next("comprehension")).variable().synthetic();
        Block mainBlock = Block.empty();
        for (GoloAssignment<?> a : collection.declarations()) {
            mainBlock.add(a);
        }
        collection.clearDeclarations();
        mainBlock.add(AssignmentStatement.create(tempVar, CollectionLiteral.create((Object)tempColType, new Object[0]), true));
        Block innerBlock = mainBlock;
        for (GoloStatement<?> loop : collection.loops()) {
            innerBlock.add(loop);
            innerBlock = ((BlockContainer)((Object)loop)).getBlock();
        }
        innerBlock.add(MethodInvocation.invoke("add").withArgs(collection.expression()).on(tempVar.lookup()));
        if (collection.getType() == CollectionLiteral.Type.array || collection.getType() == CollectionLiteral.Type.tuple) {
            mainBlock.add(AssignmentStatement.create(tempVar, MethodInvocation.invoke("toArray").on(tempVar.lookup()), false));
        }
        if (collection.getType() == CollectionLiteral.Type.tuple) {
            mainBlock.add(AssignmentStatement.create(tempVar, FunctionInvocation.of("Tuple.fromArray").withArgs(tempVar.lookup()), false));
        }
        mainBlock.add(tempVar.lookup());
        collection.replaceInParentBy(mainBlock);
        mainBlock.accept(this);
    }

    @Override
    public void visitForEachLoopStatement(ForEachLoopStatement foreachStatement) {
        LocalReference iterVar = LocalReference.of(this.symbols.next("forEachIterator")).variable().synthetic();
        Block loopInnerBlock = foreachStatement.hasWhenClause() ? (Block)Block.of(ConditionalBranching.branch().condition(foreachStatement.getWhenClause()).whenTrue(foreachStatement.getBlock())).positionInSourceCode(foreachStatement.positionInSourceCode()) : foreachStatement.getBlock();
        if (foreachStatement.isDestructuring()) {
            loopInnerBlock.prepend(((DestructuringAssignment)DestructuringAssignment.destruct(MethodInvocation.invoke("next").on(iterVar.lookup())).declaring()).varargs(foreachStatement.isVarargs()).to(foreachStatement.getReferences()));
        } else {
            loopInnerBlock.prepend(AssignmentStatement.create(foreachStatement.getLocalReference(), MethodInvocation.invoke("next").on(iterVar.lookup()), true));
        }
        LoopStatement newLoop = LoopStatement.loop().init(AssignmentStatement.create(iterVar, MethodInvocation.invoke("iterator").on(foreachStatement.getIterable()), true)).condition(MethodInvocation.invoke("hasNext").on(iterVar.lookup())).block(loopInnerBlock);
        foreachStatement.replaceInParentBy(newLoop);
        newLoop.accept(this);
    }

    @Override
    public void visitDestructuringAssignment(DestructuringAssignment assignment) {
        LocalReference tmpRef = LocalReference.of(this.symbols.next("destruct")).synthetic();
        Block block = Block.of(AssignmentStatement.create(tmpRef, MethodInvocation.invoke("destruct").on(assignment.expression()), true));
        int last = assignment.getReferencesCount() - 1;
        int idx = 0;
        for (LocalReference ref : assignment.getReferences()) {
            block.add(AssignmentStatement.create(ref, MethodInvocation.invoke(assignment.isVarargs() && idx == last ? "subTuple" : "get").withArgs(ConstantStatement.of(idx)).on(tmpRef.lookup()), assignment.isDeclaring()));
            ++idx;
        }
        assignment.replaceInParentBy(block);
        block.accept(this);
    }

    @Override
    public void visitStruct(Struct struct) {
        this.module.addFunctions(struct.createFactories());
    }

    @Override
    public void visitBinaryOperation(BinaryOperation op) {
        this.visitExpression(op);
    }

    @Override
    public void visitUnaryOperation(UnaryOperation op) {
        this.visitExpression(op);
    }

    @Override
    public void visitReferenceLookup(ReferenceLookup ref) {
        this.visitExpression(ref);
    }

    @Override
    public void visitFunctionInvocation(FunctionInvocation fun) {
        this.visitExpression(fun);
    }

    @Override
    public void visitMethodInvocation(MethodInvocation invoke) {
        this.visitExpression(invoke);
    }

    private void visitExpression(ExpressionStatement<?> expr) {
        if (!this.expressionToBlock(expr)) {
            expr.walk(this);
        }
    }

    private boolean expressionToBlock(ExpressionStatement<?> expr) {
        if (!expr.hasLocalDeclarations()) {
            return false;
        }
        Block b = Block.block(expr.declarations());
        expr.replaceInParentBy(b);
        expr.clearDeclarations();
        LocalReference r = LocalReference.of(this.symbols.next("localdec")).synthetic();
        b.add(AssignmentStatement.create(r, expr, true));
        b.add(r.lookup());
        b.accept(this);
        return true;
    }
}

