/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import gololang.Messages;
import gololang.ir.GoloElement;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.compiler.PositionInSourceCode;
import org.eclipse.golo.compiler.parser.GoloASTNode;
import org.eclipse.golo.compiler.parser.ParseException;

public class GoloCompilationException
extends RuntimeException {
    private final List<Problem> problems = new LinkedList<Problem>();
    private String sourceCode;

    public List<Problem> getProblems() {
        return Collections.unmodifiableList(this.problems);
    }

    private void report(Problem problem) {
        this.problems.add(problem);
    }

    private GoloCompilationException() {
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public GoloCompilationException(String message) {
        super(message);
    }

    public GoloCompilationException(Throwable throwable) {
        super(throwable);
    }

    public GoloCompilationException(String message, Throwable cause) {
        super(message, cause);
    }

    public static class Builder {
        private final GoloCompilationException exception;

        public Builder(String goloSourceFilename) {
            this.exception = new GoloCompilationException(Messages.message("in_module", goloSourceFilename));
            this.exception.setSourceCode(goloSourceFilename);
        }

        public Builder report(Problem.Type type, GoloASTNode source, String description) {
            this.exception.report(new Problem(type, source != null ? source.getPositionInSourceCode() : null, description, source, null));
            return this;
        }

        public Builder report(Problem.Type type, GoloElement<?> source, String description) {
            this.exception.report(new Problem(type, source != null ? source.positionInSourceCode() : null, description, source, null));
            return this;
        }

        public Builder report(Problem.Type type, GoloElement<?> source, String description, Throwable cause) {
            this.exception.report(new Problem(type, source != null ? source.positionInSourceCode() : null, description, source, cause));
            return this;
        }

        public Builder report(ParseException pe, GoloASTNode source) {
            this.exception.report(new Problem(Problem.Type.PARSING, PositionInSourceCode.of(pe.currentToken.beginLine, pe.currentToken.beginColumn, pe.currentToken.endLine, pe.currentToken.endColumn), pe.getMessage(), source, pe));
            return this;
        }

        public Builder report(UnsupportedCharsetException uce) {
            this.exception.report(new Problem(Problem.Type.INVALID_ENCODING, null, uce.getMessage(), null, uce));
            return this;
        }

        public void doThrow() throws GoloCompilationException {
            throw this.exception;
        }

        public List<Problem> getProblems() {
            return this.exception.getProblems();
        }
    }

    public static final class Problem {
        private final Type type;
        private final PositionInSourceCode position;
        private final String description;
        private final Object source;
        private final Throwable cause;

        private Problem(Type type, PositionInSourceCode position, String description, Object source, Throwable cause) {
            this.type = type;
            this.position = position;
            this.description = description;
            this.source = source;
            this.cause = cause;
        }

        public Type getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public PositionInSourceCode getPositionInSourceCode() {
            return this.position;
        }

        public Object getSource() {
            return this.source;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            return String.format("Problem{type=%s, description='%s', position=%s}", new Object[]{this.type, this.description, this.position});
        }

        public static enum Type {
            PARSING,
            AUGMENT_FUNCTION_NO_ARGS,
            UNDECLARED_REFERENCE,
            ASSIGN_CONSTANT,
            BREAK_OR_CONTINUE_OUTSIDE_LOOP,
            REFERENCE_ALREADY_DECLARED_IN_BLOCK,
            UNINITIALIZED_REFERENCE_ACCESS,
            INVALID_ENCODING,
            INCOMPLETE_NAMED_ARGUMENTS_USAGE,
            AMBIGUOUS_DECLARATION;

        }
    }
}

