/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import gololang.ir.GoloModule;
import java.io.InputStream;
import java.util.List;
import org.eclipse.golo.compiler.CodeGenerationResult;
import org.eclipse.golo.compiler.GoloCompilationException;
import org.eclipse.golo.compiler.GoloCompiler;

public class GoloClassLoader
extends ClassLoader {
    private final GoloCompiler compiler = new GoloCompiler();

    public GoloClassLoader(ClassLoader parent) {
        super(parent);
    }

    public GoloClassLoader() {
    }

    public GoloCompiler getCompiler() {
        return this.compiler;
    }

    public synchronized Class<?> load(String goloSourceFilename, InputStream sourceCodeInputStream) throws GoloCompilationException {
        return this.load(this.compiler.compile(goloSourceFilename, sourceCodeInputStream));
    }

    public synchronized Class<?> load(String goloSourceFilename, GoloModule module) {
        this.compiler.refine(module);
        return this.load(this.compiler.generate(module, goloSourceFilename));
    }

    private Class<?> load(List<CodeGenerationResult> results) {
        Class<?> lastClassIsModule = null;
        for (CodeGenerationResult result : results) {
            byte[] bytecode = result.getBytecode();
            lastClassIsModule = this.defineClass(null, bytecode, 0, bytecode.length);
        }
        return lastClassIsModule;
    }
}

