/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloType;
import gololang.ir.ToplevelGoloElement;
import gololang.ir.UnionValue;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class Union
extends GoloType<Union>
implements ToplevelGoloElement {
    private final Set<UnionValue> values = new LinkedHashSet<UnionValue>();

    private Union(String name) {
        super(name);
    }

    public static Union union(String name) {
        return new Union(name);
    }

    @Override
    protected Union self() {
        return this;
    }

    public boolean addValue(UnionValue value) {
        this.makeParentOf(value);
        return this.values.add(value);
    }

    public boolean addElement(GoloElement<?> elt) {
        if (elt instanceof UnionValue) {
            return this.addValue((UnionValue)elt);
        }
        throw Union.cantConvert("UnionValue", elt);
    }

    public Collection<UnionValue> getValues() {
        return Collections.unmodifiableSet(this.values);
    }

    public Union value(String name, Object ... members) {
        UnionValue value = new UnionValue(name);
        value.members(members);
        this.addValue(value);
        return this;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitUnion(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        LinkedList children = new LinkedList(this.values);
        return children;
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (!this.values.contains(original)) {
            throw this.cantReplace(original, newElement);
        }
        this.values.remove(original);
        this.addElement(newElement);
    }
}

