/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.FunctionInvocation;
import gololang.ir.GoloElement;
import gololang.ir.GoloFunction;
import gololang.ir.GoloType;
import gololang.ir.Member;
import gololang.ir.ReferenceLookup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class TypeWithMembers<T extends TypeWithMembers<T>>
extends GoloType<T> {
    private final Set<Member> members = new LinkedHashSet<Member>();

    TypeWithMembers(String name) {
        super(name);
    }

    protected String getFactoryDelegateName() {
        return this.getFullName();
    }

    @Override
    String getFullName() {
        return this.getPackageAndClass().toString();
    }

    public T members(Object ... members) {
        for (Object member : members) {
            this.withMember(member);
        }
        return (T)((TypeWithMembers)this.self());
    }

    public boolean hasMembers() {
        return !this.members.isEmpty();
    }

    protected void addMember(Member member) {
        this.members.add(this.makeParentOf(member));
    }

    void addMembers(Iterable<Member> members) {
        members.forEach(this::addMember);
    }

    public T withMember(Object member) {
        this.addMember(Member.of(member));
        return (T)((TypeWithMembers)this.self());
    }

    protected List<String> getMemberNames() {
        return this.members.stream().map(Member::getName).collect(Collectors.toList());
    }

    public Set<Member> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    public List<Member> getPublicMembers() {
        return this.members.stream().filter(Member::isPublic).collect(Collectors.toList());
    }

    protected Object[] getFullArgs() {
        return this.members.stream().map(Member::getName).map(ReferenceLookup::of).toArray();
    }

    public Set<GoloFunction> createFactories() {
        LinkedHashSet<GoloFunction> factories = new LinkedHashSet<GoloFunction>();
        factories.add(this.createFullArgsConstructor());
        return factories;
    }

    protected GoloFunction createFullArgsConstructor() {
        return GoloFunction.function(this.getName()).synthetic().withParameters(this.getMemberNames()).returns(FunctionInvocation.of(this.getFactoryDelegateName()).withArgs(this.getFullArgs()));
    }

    @Override
    public List<GoloElement<?>> children() {
        return new ArrayList(this.members);
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        throw this.cantReplace();
    }
}

