/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.Alternatives;
import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.WhenClause;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class MatchExpression
extends ExpressionStatement<MatchExpression>
implements Alternatives<ExpressionStatement<?>> {
    private ExpressionStatement<?> otherwise;
    private final LinkedList<WhenClause<ExpressionStatement<?>>> clauses = new LinkedList();

    MatchExpression() {
    }

    public static MatchExpression match() {
        return new MatchExpression();
    }

    @Override
    protected MatchExpression self() {
        return this;
    }

    public MatchExpression when(Object cond) {
        if (cond instanceof WhenClause) {
            WhenClause clause = (WhenClause)cond;
            this.clauses.add(this.makeParentOf(clause));
        } else {
            this.clauses.add(this.makeParentOf(new WhenClause<Object>(ExpressionStatement.of(cond), null)));
        }
        return this;
    }

    public MatchExpression then(Object action) {
        this.clauses.getLast().then(ExpressionStatement.of(action));
        return this;
    }

    public MatchExpression otherwise(Object action) {
        this.otherwise = this.makeParentOf(ExpressionStatement.of(action));
        return this;
    }

    @Override
    public List<WhenClause<ExpressionStatement<?>>> getClauses() {
        return Collections.unmodifiableList(this.clauses);
    }

    @Override
    public ExpressionStatement<?> getOtherwise() {
        return this.otherwise;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitMatchExpression(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        LinkedList children = new LinkedList(this.clauses);
        children.add(this.otherwise);
        return children;
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (!(newElement instanceof ExpressionStatement) && !(newElement instanceof WhenClause)) {
            throw MatchExpression.cantConvert("ExpressionStatement or WhenClause", newElement);
        }
        if (this.otherwise.equals(original)) {
            this.otherwise(newElement);
            return;
        }
        if (this.clauses.contains(original)) {
            WhenClause when = (WhenClause)newElement;
            this.clauses.set(this.clauses.indexOf(original), this.makeParentOf(when));
            return;
        }
        throw this.doesNotContain(original);
    }
}

