/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.BinaryOperation;
import gololang.ir.ConstantStatement;
import gololang.ir.FunctionInvocation;
import gololang.ir.GoloAssignment;
import gololang.ir.GoloStatement;
import gololang.ir.LocalReference;
import gololang.ir.OperatorType;
import java.util.LinkedList;

public abstract class ExpressionStatement<T extends ExpressionStatement<T>>
extends GoloStatement<T> {
    private final LinkedList<GoloAssignment<?>> declarations = new LinkedList();

    public T with(Object a) {
        if (!(a instanceof GoloAssignment)) {
            throw new IllegalArgumentException("Must be an assignment, got " + a);
        }
        GoloAssignment declaration = (GoloAssignment)a;
        this.declarations.add((GoloAssignment<?>)declaration.declaring());
        this.makeParentOf(declaration);
        return (T)((ExpressionStatement)this.self());
    }

    public GoloAssignment<?>[] declarations() {
        return this.declarations.toArray(new GoloAssignment[this.declarations.size()]);
    }

    public boolean hasLocalDeclarations() {
        return !this.declarations.isEmpty();
    }

    public void clearDeclarations() {
        this.declarations.clear();
    }

    public BinaryOperation call(Object ... arguments) {
        FunctionInvocation invocation;
        if (arguments.length == 1 && arguments[0] instanceof FunctionInvocation) {
            invocation = (FunctionInvocation)arguments[0];
            if (!invocation.isAnonymous()) {
                throw new IllegalArgumentException("Invocation in anonymous calls must be anonymous.");
            }
        } else {
            invocation = FunctionInvocation.of(null).withArgs(arguments);
        }
        return BinaryOperation.create((Object)OperatorType.ANON_CALL, this, invocation);
    }

    public static ExpressionStatement<?> of(Object expr) {
        if (expr instanceof ExpressionStatement) {
            return (ExpressionStatement)expr;
        }
        if (ConstantStatement.isLiteralValue(expr)) {
            return ConstantStatement.of(expr);
        }
        if (expr instanceof LocalReference) {
            return ((LocalReference)expr).lookup();
        }
        throw ExpressionStatement.cantConvert("ExpressionStatement", expr);
    }
}

