/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.MethodInvocation;
import gololang.ir.OperatorType;
import java.util.Arrays;
import java.util.List;

public final class BinaryOperation
extends ExpressionStatement<BinaryOperation> {
    private final OperatorType type;
    private ExpressionStatement<?> leftExpression;
    private ExpressionStatement<?> rightExpression;

    private BinaryOperation(OperatorType type) {
        this.type = type;
    }

    public static BinaryOperation of(Object type) {
        return new BinaryOperation(OperatorType.of(type));
    }

    public static BinaryOperation create(Object type, Object left, Object right) {
        return BinaryOperation.of(type).left(left).right(right);
    }

    @Override
    protected BinaryOperation self() {
        return this;
    }

    public OperatorType getType() {
        return this.type;
    }

    public ExpressionStatement<?> left() {
        return this.leftExpression;
    }

    public BinaryOperation left(Object expr) {
        this.leftExpression = this.makeParentOf(ExpressionStatement.of(expr));
        return this;
    }

    public BinaryOperation right(Object expr) {
        this.rightExpression = this.makeParentOf(ExpressionStatement.of(expr));
        if (this.type == OperatorType.ELVIS_METHOD_CALL && this.rightExpression instanceof MethodInvocation) {
            ((MethodInvocation)this.rightExpression).nullSafe(true);
        }
        return this;
    }

    public ExpressionStatement<?> right() {
        return this.rightExpression;
    }

    public String toString() {
        return String.format("%s %s %s", new Object[]{this.leftExpression, this.type, this.rightExpression});
    }

    public boolean isMethodCall() {
        return this.getType() == OperatorType.METHOD_CALL || this.getType() == OperatorType.ELVIS_METHOD_CALL || this.getType() == OperatorType.ANON_CALL;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitBinaryOperation(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        return Arrays.asList(this.leftExpression, this.rightExpression);
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (!(newElement instanceof ExpressionStatement)) {
            throw BinaryOperation.cantConvert("ExpressionStatement", newElement);
        }
        if (this.leftExpression.equals(original)) {
            this.left(newElement);
        } else if (this.rightExpression.equals(original)) {
            this.right(newElement);
        } else {
            throw this.cantReplace(original, newElement);
        }
    }
}

