/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark.cmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class HlUtils {
    static final AtomicInteger IN_COUNT = new AtomicInteger(0);
    static final AtomicInteger OUT_COUNT = new AtomicInteger(0);
    static final long ID = System.nanoTime();

    HlUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String highlight(List<String> lines, String meta, String prog, String encoding) throws IOException {
        File tmpIn = new File(System.getProperty("java.io.tmpdir"), String.format("txtmark_code_%d_%d.in", ID, IN_COUNT.incrementAndGet()));
        File tmpOut = new File(System.getProperty("java.io.tmpdir"), String.format("txtmark_code_%d_%d.out", ID, OUT_COUNT.incrementAndGet()));
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpIn), encoding);
            try {
                for (String s : lines) {
                    w.write(s);
                    ((Writer)w).write(10);
                }
            }
            finally {
                ((Writer)w).close();
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add(prog);
            command.add(meta);
            command.add(tmpIn.getAbsolutePath());
            command.add(tmpOut.getAbsolutePath());
            ProcessBuilder pb = new ProcessBuilder(command);
            Process p = pb.start();
            InputStream pIn = p.getInputStream();
            byte[] buffer = new byte[2048];
            int exitCode = 0;
            while (true) {
                if (pIn.available() > 0) {
                    pIn.read(buffer);
                }
                try {
                    exitCode = p.exitValue();
                }
                catch (IllegalThreadStateException itse) {
                    continue;
                }
                break;
            }
            if (exitCode == 0) {
                InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(tmpOut), encoding);
                try {
                    int c;
                    StringBuilder sb = new StringBuilder();
                    while ((c = ((Reader)r).read()) >= 0) {
                        sb.append((char)c);
                    }
                    String string = sb.toString();
                    return string;
                }
                finally {
                    ((Reader)r).close();
                }
            }
            throw new IOException("Exited with exit code: " + exitCode);
        }
        finally {
            tmpIn.delete();
            tmpOut.delete();
        }
    }

    public static void escapedAdd(StringBuilder sb, String str) {
        block7: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch < '!' || Character.isWhitespace(ch) || Character.isSpaceChar(ch)) {
                sb.append(' ');
                continue;
            }
            switch (ch) {
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
    }
}

