/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import gololang.Messages;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class NamedArgumentsHelper {
    private NamedArgumentsHelper() {
    }

    public static Boolean hasNamedParameters(Method method) {
        return Arrays.stream(method.getParameters()).allMatch(Parameter::isNamePresent);
    }

    public static List<String> getParameterNames(Method method) {
        return Arrays.stream(method.getParameters()).map(Parameter::getName).collect(Collectors.toList());
    }

    public static void checkArgumentPosition(int position, String argument, String declaration) {
        if (position == -1) {
            throw new IllegalArgumentException(Messages.message("invalid_argument_name", argument, declaration));
        }
    }
}

